/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl.methods;

import java.util.Arrays;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;

public class DslToStringHelpers {
    public static String concat(String ... x) {
        StringBuilder r = new StringBuilder();
        for (String xi : x) {
            r.append(Strings.removeFromStart((String)xi, (String)"$brooklyn:"));
        }
        if (r.length() == 0) {
            return "";
        }
        return "$brooklyn:" + r.toString();
    }

    public static String fn(String functionName, Iterable<?> args) {
        StringBuilder out = new StringBuilder();
        out.append("$brooklyn:");
        out.append(functionName);
        out.append("(");
        if (args != null) {
            boolean nonFirst = false;
            for (Object s : args) {
                if (nonFirst) {
                    out.append(", ");
                }
                out.append(DslToStringHelpers.internal(s));
                nonFirst = true;
            }
        }
        out.append(")");
        return out.toString();
    }

    public static String fn(String functionName, Object ... args) {
        return DslToStringHelpers.fn(functionName, Arrays.asList(args));
    }

    public static String internal(Object x) {
        if (x == null) {
            return "null";
        }
        if (x instanceof String) {
            return StringEscapes.JavaStringEscapes.wrapJavaString((String)((String)x));
        }
        if (x instanceof BrooklynObject) {
            return DslToStringHelpers.fn("entity", MutableList.of((Object)((BrooklynObject)x).getId()));
        }
        return Strings.removeFromStart((String)x.toString(), (String)"$brooklyn:");
    }

    public static String component(DslComponent component, String remainder) {
        return component == null || component.getScope() == DslComponent.Scope.THIS ? remainder : DslToStringHelpers.concat(DslToStringHelpers.internal(component), ".", remainder);
    }
}

