/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindTagsToIndexedFormParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Map tagValues;
        Preconditions.checkNotNull((Object)input, (Object)"tags");
        if (input instanceof Iterable) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String key : (Iterable)input) {
                builder.put((Object)key, (Object)"");
            }
            tagValues = builder.build();
        } else if (input instanceof Map) {
            tagValues = (Map)Map.class.cast(input);
        } else {
            throw new IllegalArgumentException("This binder is only valid for Map<String,String> or Iterable<String>");
        }
        return (R)AWSUtils.indexMapToFormValuesWithPrefix(request, (String)"Tag", (String)"Key", (String)"Value", (Object)tagValues);
    }
}

