/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.test.framework;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.test.framework.TargetableTestComponent;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TargetableTestComponentImpl
extends AbstractEntity
implements TargetableTestComponent {
    private static final Logger LOG = LoggerFactory.getLogger(TargetableTestComponentImpl.class);

    @Override
    public Entity resolveTarget() {
        return (Entity)this.tryResolveTarget().get();
    }

    protected Maybe<Entity> tryResolveTarget() {
        Entity target = TargetableTestComponentImpl.resolveTarget(this.getExecutionContext(), this);
        this.sensors().set((AttributeSensor)TARGET_ENTITY, (Object)target);
        if (target != null) {
            this.sensors().set(TARGET_ENTITY_ID, (Object)target.getId());
            this.sensors().set(TARGET_ENTITY_NAME, (Object)target.getDisplayName());
            this.sensors().set(TARGET_ENTITY_TYPE, (Object)target.getEntityType().getName());
            return Maybe.of((Object)target);
        }
        return Maybe.absent((String)"Cannot resolve target entity");
    }

    public static Entity resolveTarget(ExecutionContext executionContext, Entity entity) {
        Entity target = (Entity)entity.getConfig((ConfigKey.HasConfigKey)TARGET_ENTITY);
        if (null == target) {
            target = TargetableTestComponentImpl.getTargetById(executionContext, entity);
        }
        return target;
    }

    private static Entity getTargetById(final ExecutionContext executionContext, Entity entity) {
        final String targetId = (String)entity.getConfig(TARGET_ID);
        Duration resolutionTimeout = (Duration)entity.getConfig(TARGET_RESOLUTION_TIMEOUT);
        if (targetId == null) {
            return null;
        }
        final AtomicReference result = new AtomicReference();
        final DslComponent dslComponent = new DslComponent(DslComponent.Scope.GLOBAL, targetId);
        Callable<Boolean> resolver = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Task task = dslComponent.newTask();
                result.set(Tasks.resolveValue((Object)task, Entity.class, (ExecutionContext)executionContext, (String)("Finding entity " + targetId)));
                return true;
            }
        };
        try {
            if (resolutionTimeout == null || resolutionTimeout.toMilliseconds() <= 0L) {
                resolver.call();
            } else {
                Repeater.create((String)("find entity " + targetId)).backoffTo(resolutionTimeout.multiply(0.1)).limitTimeTo(resolutionTimeout).rethrowException().until((Callable)resolver).runRequiringTrue();
            }
            LOG.debug("Found target {} by id {}", result.get(), (Object)targetId);
            return (Entity)result.get();
        }
        catch (Exception e) {
            LOG.error("Error finding target {}", (Object)targetId);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected <T> T getRequiredConfig(ConfigKey<T> key) {
        return (T)Preconditions.checkNotNull((Object)this.config().get(key), (String)"config %s must not be null", key);
    }

    protected void setUpAndRunState(boolean up, Lifecycle status) {
        if (up) {
            this.sensors().set(SERVICE_UP, (Object)up);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)status);
        } else {
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)status);
            this.sensors().set(SERVICE_UP, (Object)up);
        }
    }
}

