/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResources;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperationsBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperationsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MatchResourcesFluent<A extends MatchResourcesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NamedRuleWithOperationsBuilder> excludeResourceRules = new ArrayList();
    private String matchPolicy;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder objectSelector;
    private ArrayList<NamedRuleWithOperationsBuilder> resourceRules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MatchResourcesFluent() {
    }

    public MatchResourcesFluent(MatchResources instance) {
        MatchResources matchResources = instance = instance != null ? instance : new MatchResources();
        if (instance != null) {
            this.withExcludeResourceRules(instance.getExcludeResourceRules());
            this.withMatchPolicy(instance.getMatchPolicy());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withObjectSelector(instance.getObjectSelector());
            this.withResourceRules(instance.getResourceRules());
            this.withExcludeResourceRules(instance.getExcludeResourceRules());
            this.withMatchPolicy(instance.getMatchPolicy());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withObjectSelector(instance.getObjectSelector());
            this.withResourceRules(instance.getResourceRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToExcludeResourceRules(int index, NamedRuleWithOperations item) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.excludeResourceRules.size()) {
            this._visitables.get((Object)"excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        } else {
            this._visitables.get((Object)"excludeResourceRules").add(index, builder);
            this.excludeResourceRules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExcludeResourceRules(int index, NamedRuleWithOperations item) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.excludeResourceRules.size()) {
            this._visitables.get((Object)"excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        } else {
            this._visitables.get((Object)"excludeResourceRules").set(index, builder);
            this.excludeResourceRules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExcludeResourceRules(NamedRuleWithOperations ... items) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"excludeResourceRules").add(builder);
            this.excludeResourceRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExcludeResourceRules(NamedRuleWithOperations ... items) {
        if (this.excludeResourceRules == null) {
            return (A)((Object)this);
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"excludeResourceRules").remove((Object)builder);
            this.excludeResourceRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
        if (this.excludeResourceRules == null) {
            return (A)((Object)this);
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"excludeResourceRules").remove((Object)builder);
            this.excludeResourceRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExcludeResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        if (this.excludeResourceRules == null) {
            return (A)((Object)this);
        }
        Iterator<NamedRuleWithOperationsBuilder> each = this.excludeResourceRules.iterator();
        List visitables = this._visitables.get((Object)"excludeResourceRules");
        while (each.hasNext()) {
            NamedRuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NamedRuleWithOperations> buildExcludeResourceRules() {
        return this.excludeResourceRules != null ? MatchResourcesFluent.build(this.excludeResourceRules) : null;
    }

    public NamedRuleWithOperations buildExcludeResourceRule(int index) {
        return this.excludeResourceRules.get(index).build();
    }

    public NamedRuleWithOperations buildFirstExcludeResourceRule() {
        return this.excludeResourceRules.get(0).build();
    }

    public NamedRuleWithOperations buildLastExcludeResourceRule() {
        return this.excludeResourceRules.get(this.excludeResourceRules.size() - 1).build();
    }

    public NamedRuleWithOperations buildMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.excludeResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.excludeResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExcludeResourceRules(List<NamedRuleWithOperations> excludeResourceRules) {
        if (this.excludeResourceRules != null) {
            this._visitables.get((Object)"excludeResourceRules").clear();
        }
        if (excludeResourceRules != null) {
            this.excludeResourceRules = new ArrayList();
            for (NamedRuleWithOperations item : excludeResourceRules) {
                this.addToExcludeResourceRules(item);
            }
        } else {
            this.excludeResourceRules = null;
        }
        return (A)((Object)this);
    }

    public A withExcludeResourceRules(NamedRuleWithOperations ... excludeResourceRules) {
        if (this.excludeResourceRules != null) {
            this.excludeResourceRules.clear();
            this._visitables.remove((Object)"excludeResourceRules");
        }
        if (excludeResourceRules != null) {
            for (NamedRuleWithOperations item : excludeResourceRules) {
                this.addToExcludeResourceRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExcludeResourceRules() {
        return this.excludeResourceRules != null && !this.excludeResourceRules.isEmpty();
    }

    public ExcludeResourceRulesNested<A> addNewExcludeResourceRule() {
        return new ExcludeResourceRulesNested(-1, null);
    }

    public ExcludeResourceRulesNested<A> addNewExcludeResourceRuleLike(NamedRuleWithOperations item) {
        return new ExcludeResourceRulesNested(-1, item);
    }

    public ExcludeResourceRulesNested<A> setNewExcludeResourceRuleLike(int index, NamedRuleWithOperations item) {
        return new ExcludeResourceRulesNested(index, item);
    }

    public ExcludeResourceRulesNested<A> editExcludeResourceRule(int index) {
        if (this.excludeResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit excludeResourceRules. Index exceeds size.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    public ExcludeResourceRulesNested<A> editFirstExcludeResourceRule() {
        if (this.excludeResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first excludeResourceRules. The list is empty.");
        }
        return this.setNewExcludeResourceRuleLike(0, this.buildExcludeResourceRule(0));
    }

    public ExcludeResourceRulesNested<A> editLastExcludeResourceRule() {
        int index = this.excludeResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last excludeResourceRules. The list is empty.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    public ExcludeResourceRulesNested<A> editMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.excludeResourceRules.size(); ++i) {
            if (!predicate.test(this.excludeResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching excludeResourceRules. No match found.");
        }
        return this.setNewExcludeResourceRuleLike(index, this.buildExcludeResourceRule(index));
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)((Object)this);
    }

    public boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public LabelSelector buildObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    public A withObjectSelector(LabelSelector objectSelector) {
        this._visitables.get((Object)"objectSelector").remove(this.objectSelector);
        if (objectSelector != null) {
            this.objectSelector = new LabelSelectorBuilder(objectSelector);
            this._visitables.get((Object)"objectSelector").add(this.objectSelector);
        } else {
            this.objectSelector = null;
            this._visitables.get((Object)"objectSelector").remove(this.objectSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    public ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNested(null);
    }

    public ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
        return new ObjectSelectorNested(item);
    }

    public ObjectSelectorNested<A> editObjectSelector() {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(null));
    }

    public ObjectSelectorNested<A> editOrNewObjectSelector() {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
        return this.withNewObjectSelectorLike(Optional.ofNullable(this.buildObjectSelector()).orElse(item));
    }

    public A addToResourceRules(int index, NamedRuleWithOperations item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get((Object)"resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get((Object)"resourceRules").add(index, builder);
            this.resourceRules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResourceRules(int index, NamedRuleWithOperations item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get((Object)"resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get((Object)"resourceRules").set(index, builder);
            this.resourceRules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResourceRules(NamedRuleWithOperations ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResourceRules(Collection<NamedRuleWithOperations> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResourceRules(NamedRuleWithOperations ... items) {
        if (this.resourceRules == null) {
            return (A)((Object)this);
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"resourceRules").remove((Object)builder);
            this.resourceRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResourceRules(Collection<NamedRuleWithOperations> items) {
        if (this.resourceRules == null) {
            return (A)((Object)this);
        }
        for (NamedRuleWithOperations item : items) {
            NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
            this._visitables.get((Object)"resourceRules").remove((Object)builder);
            this.resourceRules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)((Object)this);
        }
        Iterator<NamedRuleWithOperationsBuilder> each = this.resourceRules.iterator();
        List visitables = this._visitables.get((Object)"resourceRules");
        while (each.hasNext()) {
            NamedRuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NamedRuleWithOperations> buildResourceRules() {
        return this.resourceRules != null ? MatchResourcesFluent.build(this.resourceRules) : null;
    }

    public NamedRuleWithOperations buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public NamedRuleWithOperations buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public NamedRuleWithOperations buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    public NamedRuleWithOperations buildMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        for (NamedRuleWithOperationsBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceRules(List<NamedRuleWithOperations> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get((Object)"resourceRules").clear();
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (NamedRuleWithOperations item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)((Object)this);
    }

    public A withResourceRules(NamedRuleWithOperations ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
            this._visitables.remove((Object)"resourceRules");
        }
        if (resourceRules != null) {
            for (NamedRuleWithOperations item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    public ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNested(-1, null);
    }

    public ResourceRulesNested<A> addNewResourceRuleLike(NamedRuleWithOperations item) {
        return new ResourceRulesNested(-1, item);
    }

    public ResourceRulesNested<A> setNewResourceRuleLike(int index, NamedRuleWithOperations item) {
        return new ResourceRulesNested(index, item);
    }

    public ResourceRulesNested<A> editResourceRule(int index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    public ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MatchResourcesFluent that = (MatchResourcesFluent)((Object)o);
        if (!Objects.equals(this.excludeResourceRules, that.excludeResourceRules)) {
            return false;
        }
        if (!Objects.equals(this.matchPolicy, that.matchPolicy)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.objectSelector, that.objectSelector)) {
            return false;
        }
        if (!Objects.equals(this.resourceRules, that.resourceRules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.excludeResourceRules, this.matchPolicy, this.namespaceSelector, this.objectSelector, this.resourceRules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.excludeResourceRules != null && !this.excludeResourceRules.isEmpty()) {
            sb.append("excludeResourceRules:");
            sb.append(this.excludeResourceRules + ",");
        }
        if (this.matchPolicy != null) {
            sb.append("matchPolicy:");
            sb.append(this.matchPolicy + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.objectSelector != null) {
            sb.append("objectSelector:");
            sb.append(this.objectSelector + ",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceRulesNested<N>
    extends NamedRuleWithOperationsFluent<ResourceRulesNested<N>>
    implements Nested<N> {
        NamedRuleWithOperationsBuilder builder;
        int index;

        ResourceRulesNested(int index, NamedRuleWithOperations item) {
            this.index = index;
            this.builder = new NamedRuleWithOperationsBuilder(this, item);
        }

        public N and() {
            return (N)MatchResourcesFluent.this.setToResourceRules(this.index, this.builder.build());
        }

        public N endResourceRule() {
            return this.and();
        }
    }

    public class ObjectSelectorNested<N>
    extends LabelSelectorFluent<ObjectSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        ObjectSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)MatchResourcesFluent.this.withObjectSelector(this.builder.build());
        }

        public N endObjectSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)MatchResourcesFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class ExcludeResourceRulesNested<N>
    extends NamedRuleWithOperationsFluent<ExcludeResourceRulesNested<N>>
    implements Nested<N> {
        NamedRuleWithOperationsBuilder builder;
        int index;

        ExcludeResourceRulesNested(int index, NamedRuleWithOperations item) {
            this.index = index;
            this.builder = new NamedRuleWithOperationsBuilder(this, item);
        }

        public N and() {
            return (N)MatchResourcesFluent.this.setToExcludeResourceRules(this.index, this.builder.build());
        }

        public N endExcludeResourceRule() {
            return this.and();
        }
    }
}

