/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.server.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.util.Date;
import java.util.List;
import org.apache.brooklyn.camp.commontypes.RepresentationSkew;
import org.apache.brooklyn.camp.server.dto.DtoCustomAttributes;
import org.apache.brooklyn.camp.server.rest.util.DtoFactory;
import org.apache.brooklyn.camp.spi.AbstractResource;
import org.apache.brooklyn.util.time.Time;

public class ResourceDto
extends DtoCustomAttributes {
    private String uri;
    private String type;
    private String name;
    private String description;
    private Date created;
    private List<String> tags;
    private RepresentationSkew representationSkew;

    protected ResourceDto() {
    }

    protected ResourceDto(DtoFactory dtoFactory, AbstractResource x) {
        this.type = x.getType();
        this.name = x.getName();
        this.description = x.getDescription();
        this.setCreated(x.getCreated());
        this.tags = x.getTags();
        this.representationSkew = x.getRepresentationSkew();
        if (x.getCustomAttributes() != null && !x.getCustomAttributes().isEmpty()) {
            this.newInstanceCustomAttributes(x.getCustomAttributes());
        }
        this.uri = dtoFactory.uri(x);
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="created")
    public String getCreatedAsString() {
        return this.created == null ? null : ISO8601Utils.format((Date)this.created);
    }

    @JsonSetter
    private void setCreated(Date created) {
        this.created = Time.dropMilliseconds((Date)created);
    }

    @JsonIgnore
    public Date getCreated() {
        return this.created;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<String> getTags() {
        return this.tags;
    }

    public String getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RepresentationSkew getRepresentationSkew() {
        return this.representationSkew;
    }

    public static ResourceDto newInstance(DtoFactory dtoFactory, AbstractResource x) {
        return new ResourceDto(dtoFactory, x);
    }
}

