/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.util.ByteArrayBuffer;
import org.slf4j.Logger;

public class LoggingOutputStream
extends FilterOutputStream {
    private static final OutputStream NOOP_OUTPUT_STREAM = new FilterOutputStream(null){

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    };
    protected final Logger log;
    protected final String logPrefix;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private ByteArrayBuffer lineSoFar = new ByteArrayBuffer(16);

    public static Builder builder() {
        return new Builder();
    }

    private LoggingOutputStream(Builder builder) {
        super(builder.out != null ? builder.out : NOOP_OUTPUT_STREAM);
        this.log = builder.log;
        this.logPrefix = builder.logPrefix != null ? builder.logPrefix : "";
    }

    @Override
    public void write(int b) throws IOException {
        if (this.running.get()) {
            this.onChar(b);
        }
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        try {
            if (this.lineSoFar.length() > 0) {
                this.onLine(this.lineSoFar.buffer(), this.lineSoFar.length());
                this.clearLineSoFar();
            }
        }
        finally {
            super.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.onLine(this.lineSoFar.buffer(), this.lineSoFar.length());
            this.clearLineSoFar();
        }
        finally {
            this.out.close();
            this.running.set(false);
        }
    }

    public void onChar(int c) {
        if (c == 10 || c == 13) {
            if (this.lineSoFar.length() > 0) {
                this.onLine(this.lineSoFar.buffer(), this.lineSoFar.length());
                this.clearLineSoFar();
            }
        } else {
            this.lineSoFar.append(c);
        }
    }

    private void clearLineSoFar() {
        this.lineSoFar.setLength(0);
        if (this.lineSoFar.capacity() > 1024) {
            this.lineSoFar = new ByteArrayBuffer(16);
        }
    }

    public void onLine(byte[] line, int length) {
        this.onLine(new String(line, 0, length, StandardCharsets.UTF_8));
    }

    public void onLine(String line) {
        while (line.length() > 0 && Character.isWhitespace(line.charAt(line.length() - 1))) {
            line = line.substring(0, line.length() - 1);
        }
        while (line.length() > 0 && (line.charAt(0) == '\n' || line.charAt(0) == '\r')) {
            line = line.substring(1);
        }
        if (!line.isEmpty() && this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.logPrefix + line);
        }
    }

    public static class Builder {
        OutputStream out;
        Logger log;
        String logPrefix;

        public Builder outputStream(OutputStream val) {
            this.out = val;
            return this;
        }

        public Builder logger(Logger val) {
            this.log = val;
            return this;
        }

        public Builder logPrefix(String val) {
            this.logPrefix = val;
            return this;
        }

        public LoggingOutputStream build() {
            return new LoggingOutputStream(this);
        }
    }
}

