/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.binder;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;
import org.jclouds.rest.MapBinder;

public abstract class BaseProfitBricksRequestBinder<T>
implements MapBinder {
    protected final String paramName;

    protected BaseProfitBricksRequestBinder(String paramName) {
        this.paramName = (String)Preconditions.checkNotNull((Object)paramName, (Object)"Initialize 'paramName' in constructor");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Object obj;
        Preconditions.checkNotNull(request, (Object)"request");
        Object payload = obj = Preconditions.checkNotNull((Object)postParams.get(this.paramName), (String)"Param '%s' cannot be null.", (Object[])new Object[]{this.paramName});
        return this.createRequest(request, this.createPayload(payload));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected abstract String createPayload(T var1);

    protected static String formatIfNotEmpty(String pattern, Object param) {
        return Strings.isNullOrEmpty((String)BaseProfitBricksRequestBinder.nullableToString(param)) ? "" : String.format(pattern, param);
    }

    protected static String nullableToString(Object object) {
        return object == null ? "" : object.toString();
    }

    protected <R extends HttpRequest> R createRequest(R fromRequest, String payload) {
        BaseMutableContentMetadata metadata = new BaseMutableContentMetadata();
        metadata.setContentType("text/xml");
        metadata.setContentLength(Long.valueOf(payload.getBytes().length));
        fromRequest.setPayload(payload);
        fromRequest.getPayload().setContentMetadata((MutableContentMetadata)metadata);
        return fromRequest;
    }
}

