/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.io;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.twitter.common.base.MoreSuppliers;
import com.twitter.common.io.Codec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftCodec<T extends TBase>
implements Codec<T> {
    public static final Function<TTransport, TProtocol> JSON_PROTOCOL = new Function<TTransport, TProtocol>(){

        public TProtocol apply(TTransport transport) {
            return new TJSONProtocol(transport);
        }
    };
    public static final Function<TTransport, TProtocol> BINARY_PROTOCOL = new Function<TTransport, TProtocol>(){

        public TProtocol apply(TTransport transport) {
            return new TBinaryProtocol(transport);
        }
    };
    public static final Function<TTransport, TProtocol> COMPACT_PROTOCOL = new Function<TTransport, TProtocol>(){

        public TProtocol apply(TTransport transport) {
            return new TCompactProtocol(transport);
        }
    };
    private final Supplier<T> templateSupplier;
    private final Function<TTransport, TProtocol> protocolFactory;

    public static <T extends TBase> ThriftCodec<T> create(Class<T> thriftStructType, Function<TTransport, TProtocol> protocolFactory) {
        return new ThriftCodec<T>(MoreSuppliers.of(thriftStructType), protocolFactory);
    }

    @Deprecated
    public ThriftCodec(Class<T> thriftStructType, Function<TTransport, TProtocol> protocolFactory) {
        this((Supplier<T>)MoreSuppliers.of(thriftStructType), protocolFactory);
    }

    public ThriftCodec(Supplier<T> templateSupplier, Function<TTransport, TProtocol> protocolFactory) {
        this.templateSupplier = (Supplier)Preconditions.checkNotNull(templateSupplier);
        this.protocolFactory = (Function)Preconditions.checkNotNull(protocolFactory);
    }

    public void serialize(T item, OutputStream sink) throws IOException {
        Preconditions.checkNotNull(item);
        Preconditions.checkNotNull((Object)sink);
        try {
            item.write((TProtocol)this.protocolFactory.apply((Object)new TIOStreamTransport(null, sink)));
        }
        catch (TException e) {
            throw new IOException("Problem serializing thrift struct: " + item, e);
        }
    }

    public T deserialize(InputStream source) throws IOException {
        Preconditions.checkNotNull((Object)source);
        TBase template = (TBase)this.templateSupplier.get();
        try {
            template.read((TProtocol)this.protocolFactory.apply((Object)new TIOStreamTransport(source, null)));
        }
        catch (TException e) {
            throw new IOException("Problem de-serializing thrift struct from stream", e);
        }
        return (T)template;
    }
}

