/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SafeRunnable
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(SafeRunnable.class);

    @Override
    public void run() {
        try {
            this.safeRun();
        }
        catch (Throwable t) {
            logger.error("Unexpected throwable caught ", t);
        }
    }

    public abstract void safeRun();

    public static SafeRunnable safeRun(final Runnable runnable) {
        return new SafeRunnable(){

            @Override
            public void safeRun() {
                runnable.run();
            }
        };
    }

    public static SafeRunnable safeRun(final Runnable runnable, final Consumer<Throwable> exceptionHandler) {
        return new SafeRunnable(){

            @Override
            public void safeRun() {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    exceptionHandler.accept(t);
                    throw t;
                }
            }
        };
    }
}

