/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import org.apache.bookkeeper.util.MathUtils;

public class ServerStats {
    private static ServerStats instance = new ServerStats();
    private long packetsSent;
    private long packetsReceived;
    private long maxLatency;
    private long minLatency = Long.MAX_VALUE;
    private long totalLatency = 0L;
    private long count = 0L;

    public static ServerStats getInstance() {
        return instance;
    }

    protected ServerStats() {
    }

    public synchronized long getMinLatency() {
        return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
    }

    public synchronized long getAvgLatency() {
        if (this.count != 0L) {
            return this.totalLatency / this.count;
        }
        return 0L;
    }

    public synchronized long getMaxLatency() {
        return this.maxLatency;
    }

    public synchronized long getPacketsReceived() {
        return this.packetsReceived;
    }

    public synchronized long getPacketsSent() {
        return this.packetsSent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Latency min/avg/max: " + this.getMinLatency() + "/" + this.getAvgLatency() + "/" + this.getMaxLatency() + "\n");
        sb.append("Received: " + this.getPacketsReceived() + "\n");
        sb.append("Sent: " + this.getPacketsSent() + "\n");
        return sb.toString();
    }

    synchronized void updateLatency(long requestCreateTime) {
        long latency = MathUtils.now() - requestCreateTime;
        this.totalLatency += latency;
        ++this.count;
        if (latency < this.minLatency) {
            this.minLatency = latency;
        }
        if (latency > this.maxLatency) {
            this.maxLatency = latency;
        }
    }

    public synchronized void resetLatency() {
        this.maxLatency = 0L;
        this.count = 0L;
        this.totalLatency = 0L;
        this.minLatency = Long.MAX_VALUE;
    }

    public synchronized void resetMaxLatency() {
        this.maxLatency = this.getMinLatency();
    }

    public synchronized void incrementPacketsReceived() {
        ++this.packetsReceived;
    }

    public synchronized void incrementPacketsSent() {
        ++this.packetsSent;
    }

    public synchronized void resetRequestCounters() {
        this.packetsSent = 0L;
        this.packetsReceived = 0L;
    }
}

