/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;

public class Group {
    private Map<String, String> regExpGroupMap = new HashMap<String, String>();
    private List<String> sortedRegExpList = new ArrayList<String>();
    private List<String> groupList = new ArrayList<String>();
    private Map<String, String> pkgNameGroupMap = new HashMap<String, String>();
    private final Configuration configuration;

    public Group(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean checkPackageGroups(String groupname, String pkgNameFormList) {
        StringTokenizer strtok = new StringTokenizer(pkgNameFormList, ":");
        if (this.groupList.contains(groupname)) {
            this.configuration.message.warning("doclet.Groupname_already_used", groupname);
            return false;
        }
        this.groupList.add(groupname);
        while (strtok.hasMoreTokens()) {
            String id = strtok.nextToken();
            if (id.length() == 0) {
                this.configuration.message.warning("doclet.Error_in_packagelist", groupname, pkgNameFormList);
                return false;
            }
            if (id.endsWith("*")) {
                if (this.foundGroupFormat(this.regExpGroupMap, id = id.substring(0, id.length() - 1))) {
                    return false;
                }
                this.regExpGroupMap.put(id, groupname);
                this.sortedRegExpList.add(id);
                continue;
            }
            if (this.foundGroupFormat(this.pkgNameGroupMap, id)) {
                return false;
            }
            this.pkgNameGroupMap.put(id, groupname);
        }
        Collections.sort(this.sortedRegExpList, new MapKeyComparator());
        return true;
    }

    boolean foundGroupFormat(Map<String, ?> map, String pkgFormat) {
        if (map.containsKey(pkgFormat)) {
            this.configuration.message.error("doclet.Same_package_name_used", pkgFormat);
            return true;
        }
        return false;
    }

    public Map<String, SortedSet<PackageElement>> groupPackages(Set<PackageElement> packages) {
        String defaultGroupName;
        HashMap<String, SortedSet<PackageElement>> groupPackageMap = new HashMap<String, SortedSet<PackageElement>>();
        String string = defaultGroupName = this.pkgNameGroupMap.isEmpty() && this.regExpGroupMap.isEmpty() ? this.configuration.message.getText("doclet.Packages", new Object[0]) : this.configuration.message.getText("doclet.Other_Packages", new Object[0]);
        if (!this.groupList.contains(defaultGroupName)) {
            this.groupList.add(defaultGroupName);
        }
        for (PackageElement pkg : packages) {
            String groupName;
            String pkgName = pkg.isUnnamed() ? null : this.configuration.utils.getPackageName(pkg);
            String string2 = groupName = pkg.isUnnamed() ? null : this.pkgNameGroupMap.get(pkgName);
            if (groupName == null) {
                groupName = this.regExpGroupName(pkgName);
            }
            if (groupName == null) {
                groupName = defaultGroupName;
            }
            this.getPkgList(groupPackageMap, groupName).add(pkg);
        }
        return groupPackageMap;
    }

    String regExpGroupName(String pkgName) {
        for (String regexp : this.sortedRegExpList) {
            if (!pkgName.startsWith(regexp)) continue;
            return this.regExpGroupMap.get(regexp);
        }
        return null;
    }

    SortedSet<PackageElement> getPkgList(Map<String, SortedSet<PackageElement>> map, String groupname) {
        return map.computeIfAbsent(groupname, g -> new TreeSet<Element>(this.configuration.utils.makePackageComparator()));
    }

    public List<String> getGroupList() {
        return this.groupList;
    }

    private static class MapKeyComparator
    implements Comparator<String> {
        private MapKeyComparator() {
        }

        @Override
        public int compare(String key1, String key2) {
            return key2.length() - key1.length();
        }
    }
}

