/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.twitter.common.args.CmdLine;
import com.twitter.common.base.MorePreconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;

public final class ArgFilters {
    public static final Predicate<Field> SELECT_ALL = Predicates.alwaysTrue();

    private ArgFilters() {
    }

    public static Predicate<Field> selectPackage(final Package pkg) {
        Preconditions.checkNotNull((Object)pkg);
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.getDeclaringClass().getPackage().equals(pkg);
            }
        };
    }

    public static Predicate<Field> selectAllPackagesUnderHere(Package pkg) {
        Preconditions.checkNotNull((Object)pkg);
        final String prefix = pkg.getName() + '.';
        return Predicates.or(ArgFilters.selectPackage(pkg), (Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.getDeclaringClass().getPackage().getName().startsWith(prefix);
            }
        });
    }

    public static Predicate<Field> selectClass(final Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.getDeclaringClass().equals(clazz);
            }
        };
    }

    public static Predicate<Field> selectClasses(Class<?> ... cls) {
        Preconditions.checkNotNull(cls);
        ImmutableSet listOfClasses = ImmutableSet.copyOf((Object[])cls);
        return new Predicate<Field>((Set)listOfClasses){
            final /* synthetic */ Set val$listOfClasses;
            {
                this.val$listOfClasses = set;
            }

            public boolean apply(Field field) {
                return this.val$listOfClasses.contains(field.getDeclaringClass());
            }
        };
    }

    public static Predicate<Field> selectInstances(Object ... obj) {
        ImmutableSet setOfObjects = ImmutableSet.copyOf((Object[])obj);
        return new Predicate<Field>((Set)setOfObjects){
            final /* synthetic */ Set val$setOfObjects;
            {
                this.val$setOfObjects = set;
            }

            public boolean apply(Field field) {
                if (Modifier.isStatic(field.getModifiers())) {
                    return false;
                }
                for (Object o : this.val$setOfObjects) {
                    if (!field.getDeclaringClass().isAssignableFrom(o.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Field> selectCmdLineArg(Class<?> clazz, final String name) {
        MorePreconditions.checkNotBlank((String)name);
        return Predicates.and(ArgFilters.selectClass(clazz), (Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                return field.getAnnotation(CmdLine.class).name().equals(name);
            }
        });
    }
}

