/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.logsegment;

import org.apache.distributedlog.common.util.Sizable;
import org.apache.distributedlog.logsegment.RollingPolicy;
import org.apache.distributedlog.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeBasedRollingPolicy
implements RollingPolicy {
    static final Logger LOG = LoggerFactory.getLogger(TimeBasedRollingPolicy.class);
    final long rollingIntervalMs;

    public TimeBasedRollingPolicy(long rollingIntervalMs) {
        this.rollingIntervalMs = rollingIntervalMs;
    }

    @Override
    public boolean shouldRollover(Sizable sizable, long lastRolloverTimeMs) {
        boolean shouldSwitch;
        long elapsedMs = Utils.elapsedMSec(lastRolloverTimeMs);
        boolean bl = shouldSwitch = elapsedMs > this.rollingIntervalMs;
        if (shouldSwitch) {
            LOG.debug("Last Finalize Time: {} elapsed time (MSec): {}", (Object)lastRolloverTimeMs, (Object)elapsedMs);
        }
        return shouldSwitch;
    }
}

