/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.limiter;

import com.google.common.base.Preconditions;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.limiter.RateLimiter;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposableRequestLimiter<Request>
implements RequestLimiter<Request> {
    protected static final Logger LOG = LoggerFactory.getLogger(ComposableRequestLimiter.class);
    private final RateLimiter limiter;
    private final OverlimitFunction<Request> overlimitFunction;
    private final CostFunction<Request> costFunction;
    private final Counter overlimitCounter;

    public ComposableRequestLimiter(RateLimiter limiter, OverlimitFunction<Request> overlimitFunction, CostFunction<Request> costFunction, StatsLogger statsLogger) {
        Preconditions.checkNotNull((Object)limiter);
        Preconditions.checkNotNull(overlimitFunction);
        Preconditions.checkNotNull(costFunction);
        this.limiter = limiter;
        this.overlimitFunction = overlimitFunction;
        this.costFunction = costFunction;
        this.overlimitCounter = statsLogger.getCounter("overlimit");
    }

    @Override
    public void apply(Request request) throws OverCapacityException {
        int permits = this.costFunction.apply(request);
        if (!this.limiter.acquire(permits)) {
            this.overlimitCounter.inc();
            this.overlimitFunction.apply(request);
        }
    }

    public static interface CostFunction<Request> {
        public int apply(Request var1);
    }

    public static interface OverlimitFunction<Request> {
        public void apply(Request var1) throws OverCapacityException;
    }
}

