/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.placement;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.service.placement.PlacementStateManager;
import org.apache.distributedlog.service.placement.ServerLoad;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPlacementStateManager
implements PlacementStateManager {
    private static final Logger logger = LoggerFactory.getLogger(ZKPlacementStateManager.class);
    private static final String SERVER_LOAD_DIR = "/.server-load";
    private final String serverLoadPath;
    private final ZooKeeperClient zkClient;
    private boolean watching = false;

    public ZKPlacementStateManager(URI uri, DistributedLogConfiguration conf, StatsLogger statsLogger) {
        String zkServers = BKNamespaceDriver.getZKServersFromDLUri((URI)uri);
        this.zkClient = BKNamespaceDriver.createZKClientBuilder((String)String.format("ZKPlacementStateManager-%s", zkServers), (DistributedLogConfiguration)conf, (String)zkServers, (StatsLogger)statsLogger.scope("placement_state_manager")).build();
        this.serverLoadPath = uri.getPath() + SERVER_LOAD_DIR;
    }

    private void createServerLoadPathIfNoExists(byte[] data) throws KeeperException, IOException {
        try {
            Utils.zkCreateFullPathOptimistic((ZooKeeperClient)this.zkClient, (String)this.serverLoadPath, (byte[])data, (List)this.zkClient.getDefaultACL(), (CreateMode)CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            logger.debug("the server load path {} is already created by others", (Object)this.serverLoadPath, (Object)nee);
        }
    }

    @Override
    public void saveOwnership(TreeSet<ServerLoad> serverLoads) throws PlacementStateManager.StateManagerSaveException {
        logger.info("saving ownership");
        try {
            ZooKeeper zk = this.zkClient.get();
            byte[] timestamp = ByteBuffer.allocate(8).putLong(System.currentTimeMillis()).array();
            if (zk.exists(this.serverLoadPath, false) == null) {
                this.createServerLoadPathIfNoExists(timestamp);
            }
            Transaction tx = zk.transaction();
            List children = zk.getChildren(this.serverLoadPath, false);
            HashSet servers = new HashSet(children);
            tx.setData(this.serverLoadPath, timestamp, -1);
            for (ServerLoad serverLoad : serverLoads) {
                String server = this.serverToZkFormat(serverLoad.getServer());
                String serverPath = this.serverPath(server);
                if (servers.contains(server)) {
                    servers.remove(server);
                    tx.setData(serverPath, serverLoad.serialize(), -1);
                    continue;
                }
                tx.create(serverPath, serverLoad.serialize(), this.zkClient.getDefaultACL(), CreateMode.PERSISTENT);
            }
            for (String server : servers) {
                tx.delete(this.serverPath(server), -1);
            }
            tx.commit();
        }
        catch (IOException | InterruptedException | KeeperException e) {
            throw new PlacementStateManager.StateManagerSaveException((Exception)e);
        }
    }

    @Override
    public TreeSet<ServerLoad> loadOwnership() throws PlacementStateManager.StateManagerLoadException {
        TreeSet<ServerLoad> ownerships = new TreeSet<ServerLoad>();
        try {
            ZooKeeper zk = this.zkClient.get();
            List children = zk.getChildren(this.serverLoadPath, false);
            for (String server : children) {
                ownerships.add(ServerLoad.deserialize(zk.getData(this.serverPath(server), false, new Stat())));
            }
            return ownerships;
        }
        catch (IOException | InterruptedException | KeeperException e) {
            throw new PlacementStateManager.StateManagerLoadException((Exception)e);
        }
    }

    @Override
    public synchronized void watch(final PlacementStateManager.PlacementCallback callback) {
        if (this.watching) {
            return;
        }
        this.watching = true;
        try {
            ZooKeeper zk = this.zkClient.get();
            try {
                zk.getData(this.serverLoadPath, new Watcher(){

                    public void process(WatchedEvent watchedEvent) {
                        try {
                            callback.callback(ZKPlacementStateManager.this.loadOwnership());
                        }
                        catch (PlacementStateManager.StateManagerLoadException e) {
                            logger.error("Watch of Ownership failed", (Throwable)e);
                        }
                        finally {
                            ZKPlacementStateManager.this.watching = false;
                            ZKPlacementStateManager.this.watch(callback);
                        }
                    }
                }, new Stat());
            }
            catch (KeeperException.NoNodeException nee) {
                byte[] timestamp = ByteBuffer.allocate(8).putLong(System.currentTimeMillis()).array();
                this.createServerLoadPathIfNoExists(timestamp);
                this.watching = false;
                this.watch(callback);
            }
        }
        catch (IOException | InterruptedException | KeeperException e) {
            logger.error("Watch of Ownership failed", e);
            this.watching = false;
            this.watch(callback);
        }
    }

    public String serverPath(String server) {
        return String.format("%s/%s", this.serverLoadPath, server);
    }

    protected String serverToZkFormat(String server) {
        return server.replaceAll("/", "--");
    }

    protected String zkFormatToServer(String zkFormattedServer) {
        return zkFormattedServer.replaceAll("--", "/");
    }
}

