/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.DeprecatedTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.ParamTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.Taglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.TagletManager;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.MessageRetriever;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public abstract class TagletWriter {
    protected final boolean isFirstSentence;

    protected TagletWriter(boolean isFirstSentence) {
        this.isFirstSentence = isFirstSentence;
    }

    public abstract Content getOutputInstance();

    protected abstract Content codeTagOutput(Element var1, DocTree var2);

    protected abstract Content indexTagOutput(Element var1, DocTree var2);

    protected abstract Content getDocRootOutput();

    protected abstract Content deprecatedTagOutput(Element var1);

    protected abstract Content literalTagOutput(Element var1, DocTree var2);

    protected abstract MessageRetriever getMsgRetriever();

    protected abstract Content getParamHeader(String var1);

    protected abstract Content paramTagOutput(Element var1, DocTree var2, String var3);

    protected abstract Content propertyTagOutput(Element var1, DocTree var2, String var3);

    protected abstract Content returnTagOutput(Element var1, DocTree var2);

    protected abstract Content seeTagOutput(Element var1, List<? extends DocTree> var2);

    protected abstract Content simpleTagOutput(Element var1, List<? extends DocTree> var2, String var3);

    protected abstract Content simpleTagOutput(Element var1, DocTree var2, String var3);

    protected abstract Content getThrowsHeader();

    protected abstract Content throwsTagOutput(Element var1, DocTree var2);

    protected abstract Content throwsTagOutput(TypeMirror var1);

    protected abstract Content valueTagOutput(VariableElement var1, String var2, boolean var3);

    public static void genTagOutput(TagletManager tagletManager, Element element, List<Taglet> taglets, TagletWriter writer, Content output) {
        Utils utils = writer.configuration().utils;
        tagletManager.checkTags(utils, element, utils.getBlockTags(element), false);
        tagletManager.checkTags(utils, element, utils.getBody(element), true);
        for (Taglet taglet : taglets) {
            Content currentOutput;
            block3: {
                if (utils.isTypeElement(element) && taglet instanceof ParamTaglet || taglet instanceof DeprecatedTaglet) continue;
                currentOutput = null;
                try {
                    currentOutput = taglet.getTagletOutput(element, writer);
                }
                catch (Taglet.UnsupportedTagletOperationException utoe) {
                    List<? extends DocTree> tags = utils.getBlockTags(element, taglet.getName());
                    if (tags.isEmpty()) break block3;
                    currentOutput = taglet.getTagletOutput(element, tags.get(0), writer);
                }
            }
            if (currentOutput == null) continue;
            tagletManager.seenCustomTag(taglet.getName());
            output.addContent(currentOutput);
        }
    }

    public static Content getInlineTagOutput(Element holder, TagletManager tagletManager, DocTree holderTag, DocTree inlineTag, TagletWriter tagletWriter) {
        List<Taglet> definedTags = tagletManager.getInlineCustomTaglets();
        CommentHelper ch = tagletWriter.configuration().utils.getCommentHelper(holder);
        String inlineTagName = ch.getTagName(inlineTag);
        for (Taglet definedTag : definedTags) {
            if (!definedTag.getName().equals(inlineTagName)) continue;
            tagletManager.seenCustomTag(definedTag.getName());
            Content output = definedTag.getTagletOutput(holder, holderTag != null && definedTag.getName().equals("inheritDoc") ? holderTag : inlineTag, tagletWriter);
            return output;
        }
        return null;
    }

    public abstract Content commentTagsToOutput(DocTree var1, List<? extends DocTree> var2);

    public abstract Content commentTagsToOutput(Element var1, List<? extends DocTree> var2);

    public abstract Content commentTagsToOutput(DocTree var1, Element var2, List<? extends DocTree> var3, boolean var4);

    public abstract Configuration configuration();
}

