/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.builders;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Configuration;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.LayoutParser;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.builders.XMLNode;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public abstract class AbstractBuilder {
    protected final Configuration configuration;
    protected final Utils utils;
    protected final Set<PackageElement> containingPackagesSeen;
    protected final LayoutParser layoutParser;
    protected static final boolean DEBUG = false;

    public AbstractBuilder(Context c) {
        this.configuration = c.configuration;
        this.utils = this.configuration.utils;
        this.containingPackagesSeen = c.containingPackagesSeen;
        this.layoutParser = c.layoutParser;
    }

    public abstract String getName();

    public abstract void build() throws IOException;

    protected void build(XMLNode node, Content contentTree) {
        String component = node.name;
        try {
            this.invokeMethod("build" + component, new Class[]{XMLNode.class, Content.class}, new Object[]{node, contentTree});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            this.configuration.reporter.print(Diagnostic.Kind.ERROR, "Unknown element: " + component);
            throw new DocletAbortException(e);
        }
        catch (InvocationTargetException e) {
            throw new DocletAbortException(e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.configuration.reporter.print(Diagnostic.Kind.ERROR, "Exception " + e.getClass().getName() + " thrown while processing element: " + component);
            throw new DocletAbortException(e);
        }
    }

    protected void buildChildren(XMLNode node, Content contentTree) {
        for (XMLNode child : node.children) {
            this.build(child, contentTree);
        }
    }

    protected void invokeMethod(String methodName, Class<?>[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public static class Context {
        final Configuration configuration;
        final Set<PackageElement> containingPackagesSeen;
        final LayoutParser layoutParser;

        Context(Configuration configuration, Set<PackageElement> containingPackagesSeen, LayoutParser layoutParser) {
            this.configuration = configuration;
            this.containingPackagesSeen = containingPackagesSeen;
            this.layoutParser = layoutParser;
        }
    }
}

