/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.twitter.common.base.Command;
import com.twitter.common.base.MorePreconditions;
import com.twitter.common.net.InetSocketAddressHelper;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.zookeeper.ZooKeeperUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;

public class ZooKeeperClient {
    private static final Logger LOG = Logger.getLogger(ZooKeeperClient.class.getName());
    private static final Amount<Long, Time> WAIT_FOREVER = Amount.of((long)0L, (Unit)Time.MILLISECONDS);
    private final int sessionTimeoutMs;
    private final Credentials credentials;
    private final String zooKeeperServers;
    private final String connectString;
    private volatile ZooKeeper zooKeeper;
    private SessionState sessionState;
    private final Set<Watcher> watchers = new CopyOnWriteArraySet<Watcher>();
    private final BlockingQueue<WatchedEvent> eventQueue = new LinkedBlockingQueue<WatchedEvent>();

    public static Credentials digestCredentials(String username, String password) {
        MorePreconditions.checkNotBlank((String)username);
        Preconditions.checkNotNull((Object)password);
        return ZooKeeperClient.credentials("digest", (username + ":" + password).getBytes());
    }

    public static Credentials credentials(final String scheme, final byte[] authToken) {
        MorePreconditions.checkNotBlank((String)scheme);
        Preconditions.checkNotNull((Object)authToken);
        return new Credentials(){

            @Override
            public void authenticate(ZooKeeper zooKeeper) {
                zooKeeper.addAuthInfo(scheme, authToken);
            }

            @Override
            public String scheme() {
                return scheme;
            }

            @Override
            public byte[] authToken() {
                return authToken;
            }

            public boolean equals(Object o) {
                if (!(o instanceof Credentials)) {
                    return false;
                }
                Credentials other = (Credentials)o;
                return new EqualsBuilder().append((Object)scheme, (Object)other.scheme()).append(authToken, other.authToken()).isEquals();
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{scheme, authToken});
            }
        };
    }

    private static Iterable<InetSocketAddress> combine(InetSocketAddress address, InetSocketAddress ... addresses) {
        return ImmutableSet.builder().add((Object)address).add((Object[])addresses).build();
    }

    public ZooKeeperClient(Amount<Integer, Time> sessionTimeout, InetSocketAddress zooKeeperServer, InetSocketAddress ... zooKeeperServers) {
        this(sessionTimeout, ZooKeeperClient.combine(zooKeeperServer, zooKeeperServers));
    }

    public ZooKeeperClient(Amount<Integer, Time> sessionTimeout, Iterable<InetSocketAddress> zooKeeperServers) {
        this(sessionTimeout, Credentials.NONE, (Optional<String>)Optional.absent(), zooKeeperServers);
    }

    public ZooKeeperClient(Amount<Integer, Time> sessionTimeout, Credentials credentials, InetSocketAddress zooKeeperServer, InetSocketAddress ... zooKeeperServers) {
        this(sessionTimeout, credentials, (Optional<String>)Optional.absent(), ZooKeeperClient.combine(zooKeeperServer, zooKeeperServers));
    }

    public ZooKeeperClient(Amount<Integer, Time> sessionTimeout, Credentials credentials, Iterable<InetSocketAddress> zooKeeperServers) {
        this(sessionTimeout, credentials, (Optional<String>)Optional.absent(), zooKeeperServers);
    }

    public ZooKeeperClient(Amount<Integer, Time> sessionTimeout, Credentials credentials, Optional<String> chrootPath, Iterable<InetSocketAddress> zooKeeperServers) {
        this.sessionTimeoutMs = (Integer)((Amount)Preconditions.checkNotNull(sessionTimeout)).as((Unit)Time.MILLISECONDS);
        this.credentials = (Credentials)Preconditions.checkNotNull((Object)credentials);
        if (chrootPath.isPresent()) {
            PathUtils.validatePath((String)((String)chrootPath.get()));
        }
        Preconditions.checkNotNull(zooKeeperServers);
        Preconditions.checkArgument((!Iterables.isEmpty(zooKeeperServers) ? 1 : 0) != 0, (Object)"Must present at least 1 ZK server");
        Thread watcherProcessor = new Thread("ZookeeperClient-watcherProcessor"){

            @Override
            public void run() {
                while (true) {
                    try {
                        block3: while (true) {
                            WatchedEvent event = (WatchedEvent)ZooKeeperClient.this.eventQueue.take();
                            Iterator i$ = ZooKeeperClient.this.watchers.iterator();
                            while (true) {
                                if (!i$.hasNext()) continue block3;
                                Watcher watcher = (Watcher)i$.next();
                                watcher.process(event);
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        watcherProcessor.setDaemon(true);
        watcherProcessor.start();
        Iterable servers = Iterables.transform((Iterable)ImmutableSet.copyOf(zooKeeperServers), (Function)InetSocketAddressHelper.INET_TO_STR);
        this.zooKeeperServers = Joiner.on((char)',').join(servers);
        this.connectString = this.zooKeeperServers.concat((String)chrootPath.or((Object)""));
    }

    public boolean hasCredentials() {
        return !Strings.isNullOrEmpty((String)this.credentials.scheme()) && this.credentials.authToken() != null;
    }

    public synchronized ZooKeeper get() throws ZooKeeperConnectionException, InterruptedException {
        try {
            return this.get(WAIT_FOREVER);
        }
        catch (TimeoutException e) {
            InterruptedException interruptedException = new InterruptedException("Got an unexpected TimeoutException for 0 wait");
            interruptedException.initCause(e);
            throw interruptedException;
        }
    }

    public synchronized ZooKeeper get(Amount<Long, Time> connectionTimeout) throws ZooKeeperConnectionException, InterruptedException, TimeoutException {
        if (this.zooKeeper == null) {
            final CountDownLatch connected = new CountDownLatch(1);
            Watcher watcher = new Watcher(){

                public void process(WatchedEvent event) {
                    block0 : switch (event.getType()) {
                        case None: {
                            switch (event.getState()) {
                                case Expired: {
                                    LOG.info("Zookeeper session expired. Event: " + event);
                                    ZooKeeperClient.this.close();
                                    break block0;
                                }
                                case SyncConnected: {
                                    connected.countDown();
                                }
                            }
                        }
                    }
                    ZooKeeperClient.this.eventQueue.offer(event);
                }
            };
            try {
                this.zooKeeper = this.sessionState != null ? new ZooKeeper(this.connectString, this.sessionTimeoutMs, watcher, this.sessionState.sessionId, this.sessionState.sessionPasswd) : new ZooKeeper(this.connectString, this.sessionTimeoutMs, watcher);
            }
            catch (IOException e) {
                throw new ZooKeeperConnectionException("Problem connecting to servers: " + this.zooKeeperServers, e);
            }
            if ((Long)connectionTimeout.getValue() > 0L) {
                if (!connected.await((Long)connectionTimeout.as((Unit)Time.MILLISECONDS), TimeUnit.MILLISECONDS)) {
                    this.close();
                    throw new TimeoutException("Timed out waiting for a ZK connection after " + connectionTimeout);
                }
            } else {
                try {
                    connected.await();
                }
                catch (InterruptedException ex) {
                    LOG.info("Interrupted while waiting to connect to zooKeeper");
                    this.close();
                    throw ex;
                }
            }
            this.credentials.authenticate(this.zooKeeper);
            this.sessionState = new SessionState(this.zooKeeper.getSessionId(), this.zooKeeper.getSessionPasswd());
        }
        return this.zooKeeper;
    }

    public Watcher registerExpirationHandler(final Command onExpired) {
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.Expired) {
                    onExpired.execute();
                }
            }
        };
        this.register(watcher);
        return watcher;
    }

    public void register(Watcher watcher) {
        this.watchers.add(watcher);
    }

    public boolean unregister(Watcher watcher) {
        return this.watchers.remove(watcher);
    }

    public boolean shouldRetry(KeeperException e) {
        if (e instanceof KeeperException.SessionExpiredException) {
            this.close();
        }
        return ZooKeeperUtils.isRetryable(e);
    }

    public String getZooKeeperServers() {
        return this.zooKeeperServers;
    }

    public String getConnectString() {
        return this.connectString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.zooKeeper != null) {
            try {
                this.zooKeeper.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warning("Interrupted trying to close zooKeeper");
            }
            finally {
                this.zooKeeper = null;
                this.sessionState = null;
            }
        }
    }

    @VisibleForTesting
    synchronized boolean isClosed() {
        return this.zooKeeper == null;
    }

    @VisibleForTesting
    ZooKeeper getZooKeeperClientForTests() {
        return this.zooKeeper;
    }

    private final class SessionState {
        private final long sessionId;
        private final byte[] sessionPasswd;

        private SessionState(long sessionId, byte[] sessionPasswd) {
            this.sessionId = sessionId;
            this.sessionPasswd = sessionPasswd;
        }
    }

    public static interface Credentials {
        public static final Credentials NONE = new Credentials(){

            @Override
            public void authenticate(ZooKeeper zooKeeper) {
            }

            @Override
            public String scheme() {
                return null;
            }

            @Override
            public byte[] authToken() {
                return null;
            }
        };

        public void authenticate(ZooKeeper var1);

        @Nullable
        public String scheme();

        @Nullable
        public byte[] authToken();
    }

    public class ZooKeeperConnectionException
    extends Exception {
        public ZooKeeperConnectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

