/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.stats;

import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OwnershipStatsLogger {
    private final OwnershipStat ownershipStat;
    private final StatsReceiver ownershipStatsReceiver;
    private final ConcurrentMap<String, OwnershipStat> ownershipStats = new ConcurrentHashMap<String, OwnershipStat>();

    public OwnershipStatsLogger(StatsReceiver statsReceiver, StatsReceiver streamStatsReceiver) {
        this.ownershipStat = new OwnershipStat(statsReceiver.scope("ownership"));
        this.ownershipStatsReceiver = streamStatsReceiver.scope("perstream_ownership");
    }

    private OwnershipStat getOwnershipStat(String stream) {
        OwnershipStat stat = (OwnershipStat)this.ownershipStats.get(stream);
        if (null == stat) {
            OwnershipStat newStat = new OwnershipStat(this.ownershipStatsReceiver.scope(stream));
            OwnershipStat oldStat = this.ownershipStats.putIfAbsent(stream, newStat);
            stat = null != oldStat ? oldStat : newStat;
        }
        return stat;
    }

    public void onMiss(String stream) {
        this.ownershipStat.onMiss();
        this.getOwnershipStat(stream).onMiss();
    }

    public void onHit(String stream) {
        this.ownershipStat.onHit();
        this.getOwnershipStat(stream).onHit();
    }

    public void onRedirect(String stream) {
        this.ownershipStat.onRedirect();
        this.getOwnershipStat(stream).onRedirect();
    }

    public void onRemove(String stream) {
        this.ownershipStat.onRemove();
        this.getOwnershipStat(stream).onRemove();
    }

    public void onAdd(String stream) {
        this.ownershipStat.onAdd();
        this.getOwnershipStat(stream).onAdd();
    }

    public static class OwnershipStat {
        private final Counter hits;
        private final Counter misses;
        private final Counter removes;
        private final Counter redirects;
        private final Counter adds;

        OwnershipStat(StatsReceiver ownershipStats) {
            this.hits = ownershipStats.counter0("hits");
            this.misses = ownershipStats.counter0("misses");
            this.adds = ownershipStats.counter0("adds");
            this.removes = ownershipStats.counter0("removes");
            this.redirects = ownershipStats.counter0("redirects");
        }

        public void onHit() {
            this.hits.incr();
        }

        public void onMiss() {
            this.misses.incr();
        }

        public void onAdd() {
            this.adds.incr();
        }

        public void onRemove() {
            this.removes.incr();
        }

        public void onRedirect() {
            this.redirects.incr();
        }
    }
}

