/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client.routing;

import com.twitter.common.zookeeper.ServerSet;
import java.net.SocketAddress;
import org.apache.distributedlog.client.routing.ConsistentHashRoutingService;
import org.apache.distributedlog.client.routing.NameServerSet;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.client.routing.RoutingServiceProvider;
import org.apache.distributedlog.client.routing.SingleHostRoutingService;

public class RoutingUtils {
    private static final int NUM_CONSISTENT_HASH_REPLICAS = 997;

    public static RoutingService.Builder buildRoutingService(String finagleNameStr) {
        if (!(finagleNameStr.startsWith("serverset!") || finagleNameStr.startsWith("inet!") || finagleNameStr.startsWith("zk!"))) {
            throw new UnsupportedOperationException("Finagle Name format not supported for name: " + finagleNameStr);
        }
        return RoutingUtils.buildRoutingService(new NameServerSet(finagleNameStr), true);
    }

    public static RoutingService.Builder buildRoutingService(ServerSet serverSet) {
        return RoutingUtils.buildRoutingService(serverSet, false);
    }

    public static RoutingService.Builder buildRoutingService(SocketAddress address) {
        return SingleHostRoutingService.newBuilder().address(address);
    }

    public static RoutingService.Builder buildRoutingService(RoutingService routingService) {
        return new RoutingServiceProvider(routingService);
    }

    private static RoutingService.Builder buildRoutingService(ServerSet serverSet, boolean resolveFromName) {
        return ConsistentHashRoutingService.newBuilder().serverSet(serverSet).resolveFromName(resolveFromName).numReplicas(997);
    }
}

