/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;

public class ConfigurationService
implements HttpEndpointService {
    protected ServerConfiguration conf;

    public ConfigurationService(ServerConfiguration conf) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            String jsonResponse = this.conf.asJson();
            response.setBody(jsonResponse);
            return response;
        }
        if (HttpServer.Method.PUT == request.getMethod()) {
            String requestBody = request.getBody();
            if (null == requestBody) {
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Request body not found. should contains k-v pairs");
                return response;
            }
            HashMap configMap = (HashMap)JsonUtil.fromJson((String)requestBody, HashMap.class);
            for (Map.Entry entry : configMap.entrySet()) {
                this.conf.setProperty((String)entry.getKey(), entry.getValue());
            }
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody("Success set server config.");
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Request body not found. should contains k-v pairs");
        return response;
    }
}

