/*
 * Decompiled with CFR 0.152.
 */
package com.scurrilous.circe.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;

public class NativeUtils {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String path) throws Exception {
        Preconditions.checkArgument((boolean)path.startsWith("/"), (Object)"absolute path must start with  /");
        String[] parts = path.split("/");
        String filename = parts.length > 0 ? parts[parts.length - 1] : null;
        Path dir = Files.createTempDirectory("native", new FileAttribute[0]);
        dir.toFile().deleteOnExit();
        File temp = new File(dir.toString(), filename);
        temp.deleteOnExit();
        byte[] buffer = new byte[1024];
        InputStream input = NativeUtils.class.getResourceAsStream(path);
        if (input == null) {
            throw new FileNotFoundException("Couldn't find file into jar " + path);
        }
        try (FileOutputStream out = new FileOutputStream(temp);){
            int read;
            while ((read = input.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            input.close();
        }
        if (!temp.exists()) {
            throw new FileNotFoundException("Failed to copy file from jar at " + temp.getAbsolutePath());
        }
        System.load(temp.getAbsolutePath());
    }

    public static String libType() {
        if (OS_NAME.indexOf("mac") >= 0) {
            return "jnilib";
        }
        if (OS_NAME.indexOf("nix") >= 0 || OS_NAME.indexOf("nux") >= 0 || OS_NAME.indexOf("aix") > 0) {
            return "so";
        }
        if (OS_NAME.indexOf("win") >= 0) {
            return "dll";
        }
        throw new TypeNotPresentException(OS_NAME + " not supported", null);
    }
}

