/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.DefaultEntryLogger;
import org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.DirectEntryLogger;
import org.apache.bookkeeper.bookie.storage.directentrylogger.EntryLogIdsImpl;
import org.apache.bookkeeper.bookie.storage.ldb.EntryLocationIndex;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageRocksDB;
import org.apache.bookkeeper.bookie.storage.ldb.SingleDirectoryDbLedgerStorage;
import org.apache.bookkeeper.common.util.MathUtils;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.bookkeeper.slogger.slf4j.Slf4jSlogger;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLedgerStorage
implements LedgerStorage {
    private static final Logger log = LoggerFactory.getLogger(DbLedgerStorage.class);
    public static final String WRITE_CACHE_MAX_SIZE_MB = "dbStorage_writeCacheMaxSizeMb";
    public static final String READ_AHEAD_CACHE_MAX_SIZE_MB = "dbStorage_readAheadCacheMaxSizeMb";
    public static final String DIRECT_IO_ENTRYLOGGER = "dbStorage_directIOEntryLogger";
    public static final String DIRECT_IO_ENTRYLOGGER_TOTAL_WRITEBUFFER_SIZE_MB = "dbStorage_directIOEntryLoggerTotalWriteBufferSizeMB";
    public static final String DIRECT_IO_ENTRYLOGGER_TOTAL_READBUFFER_SIZE_MB = "dbStorage_directIOEntryLoggerTotalReadBufferSizeMB";
    public static final String DIRECT_IO_ENTRYLOGGER_READBUFFER_SIZE_MB = "dbStorage_directIOEntryLoggerReadBufferSizeMB";
    public static final String DIRECT_IO_ENTRYLOGGER_MAX_FD_CACHE_TIME_SECONDS = "dbStorage_directIOEntryLoggerMaxFdCacheTimeSeconds";
    static final String MAX_THROTTLE_TIME_MILLIS = "dbStorage_maxThrottleTimeMs";
    private static final int MB = 0x100000;
    private static final long DEFAULT_WRITE_CACHE_MAX_SIZE_MB = (long)(0.25 * (double)PlatformDependent.estimateMaxDirectMemory()) / 0x100000L;
    private static final long DEFAULT_READ_CACHE_MAX_SIZE_MB = (long)(0.25 * (double)PlatformDependent.estimateMaxDirectMemory()) / 0x100000L;
    static final String READ_AHEAD_CACHE_BATCH_SIZE = "dbStorage_readAheadCacheBatchSize";
    static final String READ_AHEAD_CACHE_BATCH_BYTES_SIZE = "dbStorage_readAheadCacheBatchBytesSize";
    private static final int DEFAULT_READ_AHEAD_CACHE_BATCH_SIZE = 100;
    private static final int DEFAULT_READ_AHEAD_CACHE_BATCH_BYTES_SIZE = -1;
    private static final long DEFAULT_DIRECT_IO_TOTAL_WRITEBUFFER_SIZE_MB = (long)(0.125 * (double)PlatformDependent.estimateMaxDirectMemory()) / 0x100000L;
    private static final long DEFAULT_DIRECT_IO_TOTAL_READBUFFER_SIZE_MB = (long)(0.125 * (double)PlatformDependent.estimateMaxDirectMemory()) / 0x100000L;
    private static final long DEFAULT_DIRECT_IO_READBUFFER_SIZE_MB = 8L;
    private static final int DEFAULT_DIRECT_IO_MAX_FD_CACHE_TIME_SECONDS = 300;
    private static final long STORAGE_FLAGS_KEY = 0L;
    private int numberOfDirs;
    private List<SingleDirectoryDbLedgerStorage> ledgerStorageList;
    private ExecutorService entryLoggerWriteExecutor = null;
    private ExecutorService entryLoggerFlushExecutor = null;
    protected ByteBufAllocator allocator;
    private static final String MAX_READAHEAD_BATCH_SIZE = "readahead-max-batch-size";
    private static final String MAX_WRITE_CACHE_SIZE = "write-cache-max-size";
    @StatsDoc(name="readahead-max-batch-size", help="the configured readahead batch size")
    private Gauge<Integer> readaheadBatchSizeGauge;
    @StatsDoc(name="write-cache-max-size", help="the configured write cache size")
    private Gauge<Long> writeCacheSizeGauge;

    @Override
    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        long writeCacheMaxSize = DbLedgerStorage.getLongVariableOrDefault(conf, WRITE_CACHE_MAX_SIZE_MB, DEFAULT_WRITE_CACHE_MAX_SIZE_MB) * 0x100000L;
        long readCacheMaxSize = DbLedgerStorage.getLongVariableOrDefault(conf, READ_AHEAD_CACHE_MAX_SIZE_MB, DEFAULT_READ_CACHE_MAX_SIZE_MB) * 0x100000L;
        boolean directIOEntryLogger = DbLedgerStorage.getBooleanVariableOrDefault(conf, DIRECT_IO_ENTRYLOGGER, false);
        this.allocator = allocator;
        this.numberOfDirs = ledgerDirsManager.getAllLedgerDirs().size();
        log.info("Started Db Ledger Storage");
        log.info(" - Number of directories: {}", (Object)this.numberOfDirs);
        log.info(" - Write cache size: {} MB", (Object)(writeCacheMaxSize / 0x100000L));
        log.info(" - Read Cache: {} MB", (Object)(readCacheMaxSize / 0x100000L));
        if (readCacheMaxSize + writeCacheMaxSize > PlatformDependent.estimateMaxDirectMemory()) {
            throw new IOException("Read and write cache sizes exceed the configured max direct memory size");
        }
        if (ledgerDirsManager.getAllLedgerDirs().size() != indexDirsManager.getAllLedgerDirs().size()) {
            throw new IOException("ledger and index dirs size not matched");
        }
        final long perDirectoryWriteCacheSize = writeCacheMaxSize / (long)this.numberOfDirs;
        long perDirectoryReadCacheSize = readCacheMaxSize / (long)this.numberOfDirs;
        final int readAheadCacheBatchSize = conf.getInt(READ_AHEAD_CACHE_BATCH_SIZE, 100);
        long readAheadCacheBatchBytesSize = conf.getInt(READ_AHEAD_CACHE_BATCH_BYTES_SIZE, -1);
        this.ledgerStorageList = Lists.newArrayList();
        for (int i = 0; i < ledgerDirsManager.getAllLedgerDirs().size(); ++i) {
            EntryLogger entrylogger;
            File ledgerDir = ledgerDirsManager.getAllLedgerDirs().get(i);
            File indexDir = indexDirsManager.getAllLedgerDirs().get(i);
            File[] lDirs = new File[]{ledgerDir.getParentFile()};
            LedgerDirsManager ldm = new LedgerDirsManager(conf, lDirs, ledgerDirsManager.getDiskChecker(), (StatsLogger)NullStatsLogger.INSTANCE);
            File[] iDirs = new File[]{indexDir.getParentFile()};
            LedgerDirsManager idm = new LedgerDirsManager(conf, iDirs, indexDirsManager.getDiskChecker(), (StatsLogger)NullStatsLogger.INSTANCE);
            if (directIOEntryLogger) {
                long perDirectoryTotalWriteBufferSize = 0x100000L * DbLedgerStorage.getLongVariableOrDefault(conf, DIRECT_IO_ENTRYLOGGER_TOTAL_WRITEBUFFER_SIZE_MB, DEFAULT_DIRECT_IO_TOTAL_WRITEBUFFER_SIZE_MB) / (long)this.numberOfDirs;
                long perDirectoryTotalReadBufferSize = 0x100000L * DbLedgerStorage.getLongVariableOrDefault(conf, DIRECT_IO_ENTRYLOGGER_TOTAL_READBUFFER_SIZE_MB, DEFAULT_DIRECT_IO_TOTAL_READBUFFER_SIZE_MB) / (long)this.numberOfDirs;
                int readBufferSize = 0x100000 * (int)DbLedgerStorage.getLongVariableOrDefault(conf, DIRECT_IO_ENTRYLOGGER_READBUFFER_SIZE_MB, 8L);
                int maxFdCacheTimeSeconds = (int)DbLedgerStorage.getLongVariableOrDefault(conf, DIRECT_IO_ENTRYLOGGER_MAX_FD_CACHE_TIME_SECONDS, 300L);
                Slf4jSlogger slog = new Slf4jSlogger(DbLedgerStorage.class);
                this.entryLoggerWriteExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("EntryLoggerWrite"));
                this.entryLoggerFlushExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("EntryLoggerFlush"));
                int numReadThreads = conf.getNumReadWorkerThreads();
                if (numReadThreads == 0) {
                    numReadThreads = conf.getServerNumIOThreads();
                }
                entrylogger = new DirectEntryLogger(ledgerDir, new EntryLogIdsImpl(ldm, (Slogger)slog), (NativeIO)new NativeIOImpl(), allocator, this.entryLoggerWriteExecutor, this.entryLoggerFlushExecutor, conf.getEntryLogSizeLimit(), conf.getNettyMaxFrameSizeBytes() - 500, perDirectoryTotalWriteBufferSize, perDirectoryTotalReadBufferSize, readBufferSize, numReadThreads, maxFdCacheTimeSeconds, (Slogger)slog, statsLogger);
            } else {
                entrylogger = new DefaultEntryLogger(conf, ldm, null, statsLogger, allocator);
            }
            this.ledgerStorageList.add(this.newSingleDirectoryDbLedgerStorage(conf, ledgerManager, ldm, idm, entrylogger, statsLogger, perDirectoryWriteCacheSize, perDirectoryReadCacheSize, readAheadCacheBatchSize, readAheadCacheBatchBytesSize));
            ldm.getListeners().forEach(ledgerDirsManager::addLedgerDirsListener);
            if (lDirs[0].getPath().equals(iDirs[0].getPath())) continue;
            idm.getListeners().forEach(indexDirsManager::addLedgerDirsListener);
        }
        this.readaheadBatchSizeGauge = new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return readAheadCacheBatchSize;
            }

            public Integer getSample() {
                return readAheadCacheBatchSize;
            }
        };
        statsLogger.registerGauge(MAX_READAHEAD_BATCH_SIZE, this.readaheadBatchSizeGauge);
        this.writeCacheSizeGauge = new Gauge<Long>(){

            public Long getDefaultValue() {
                return perDirectoryWriteCacheSize;
            }

            public Long getSample() {
                return perDirectoryWriteCacheSize;
            }
        };
        statsLogger.registerGauge(MAX_WRITE_CACHE_SIZE, this.writeCacheSizeGauge);
    }

    @VisibleForTesting
    protected SingleDirectoryDbLedgerStorage newSingleDirectoryDbLedgerStorage(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, EntryLogger entryLogger, StatsLogger statsLogger, long writeCacheSize, long readCacheSize, int readAheadCacheBatchSize, long readAheadCacheBatchBytesSize) throws IOException {
        return new SingleDirectoryDbLedgerStorage(conf, ledgerManager, ledgerDirsManager, indexDirsManager, entryLogger, statsLogger, this.allocator, writeCacheSize, readCacheSize, readAheadCacheBatchSize, readAheadCacheBatchBytesSize);
    }

    @Override
    public void setStateManager(StateManager stateManager) {
        this.ledgerStorageList.forEach(s -> s.setStateManager(stateManager));
    }

    @Override
    public void setCheckpointSource(CheckpointSource checkpointSource) {
        this.ledgerStorageList.forEach(s -> s.setCheckpointSource(checkpointSource));
    }

    @Override
    public void setCheckpointer(Checkpointer checkpointer) {
        this.ledgerStorageList.forEach(s -> s.setCheckpointer(checkpointer));
    }

    @Override
    public void start() {
        this.ledgerStorageList.forEach(LedgerStorage::start);
    }

    @Override
    public void shutdown() throws InterruptedException {
        for (LedgerStorage ledgerStorage : this.ledgerStorageList) {
            ledgerStorage.shutdown();
        }
        if (this.entryLoggerWriteExecutor != null) {
            this.entryLoggerWriteExecutor.shutdown();
        }
        if (this.entryLoggerFlushExecutor != null) {
            this.entryLoggerFlushExecutor.shutdown();
        }
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        return this.getLedgerStorage(ledgerId).ledgerExists(ledgerId);
    }

    @Override
    public boolean entryExists(long ledgerId, long entryId) throws IOException, BookieException {
        return this.getLedgerStorage(ledgerId).entryExists(ledgerId, entryId);
    }

    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        return this.getLedgerStorage(ledgerId).setFenced(ledgerId);
    }

    @Override
    public boolean isFenced(long ledgerId) throws IOException, BookieException {
        return this.getLedgerStorage(ledgerId).isFenced(ledgerId);
    }

    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        this.getLedgerStorage(ledgerId).setMasterKey(ledgerId, masterKey);
    }

    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        return this.getLedgerStorage(ledgerId).readMasterKey(ledgerId);
    }

    @Override
    public long addEntry(ByteBuf entry) throws IOException, BookieException {
        long ledgerId = entry.getLong(entry.readerIndex());
        return this.getLedgerStorage(ledgerId).addEntry(entry);
    }

    @Override
    public ByteBuf getEntry(long ledgerId, long entryId) throws IOException, BookieException {
        return this.getLedgerStorage(ledgerId).getEntry(ledgerId, entryId);
    }

    @Override
    public long getLastAddConfirmed(long ledgerId) throws IOException, BookieException {
        return this.getLedgerStorage(ledgerId).getLastAddConfirmed(ledgerId);
    }

    @Override
    public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        return this.getLedgerStorage(ledgerId).waitForLastAddConfirmedUpdate(ledgerId, previousLAC, watcher);
    }

    @Override
    public void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        this.getLedgerStorage(ledgerId).cancelWaitForLastAddConfirmedUpdate(ledgerId, watcher);
    }

    @Override
    public void flush() throws IOException {
        for (LedgerStorage ledgerStorage : this.ledgerStorageList) {
            ledgerStorage.flush();
        }
    }

    @Override
    public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        for (LedgerStorage ledgerStorage : this.ledgerStorageList) {
            ledgerStorage.checkpoint(checkpoint);
        }
    }

    @Override
    public void deleteLedger(long ledgerId) throws IOException {
        this.getLedgerStorage(ledgerId).deleteLedger(ledgerId);
    }

    @Override
    public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        this.ledgerStorageList.forEach(ls -> ls.registerLedgerDeletionListener(listener));
    }

    @Override
    public void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        this.getLedgerStorage(ledgerId).setExplicitLac(ledgerId, lac);
    }

    @Override
    public ByteBuf getExplicitLac(long ledgerId) throws IOException, BookieException {
        return this.getLedgerStorage(ledgerId).getExplicitLac(ledgerId);
    }

    public long addLedgerToIndex(long ledgerId, boolean isFenced, byte[] masterKey, LedgerCache.PageEntriesIterable pages) throws Exception {
        return this.getLedgerStorage(ledgerId).addLedgerToIndex(ledgerId, isFenced, masterKey, pages);
    }

    public long getLastEntryInLedger(long ledgerId) throws IOException {
        return this.getLedgerStorage(ledgerId).getEntryLocationIndex().getLastEntryInLedger(ledgerId);
    }

    public long getLocation(long ledgerId, long entryId) throws IOException {
        return this.getLedgerStorage(ledgerId).getEntryLocationIndex().getLocation(ledgerId, entryId);
    }

    private SingleDirectoryDbLedgerStorage getLedgerStorage(long ledgerId) {
        return this.ledgerStorageList.get(MathUtils.signSafeMod((long)ledgerId, (int)this.numberOfDirs));
    }

    public Iterable<Long> getActiveLedgersInRange(long firstLedgerId, long lastLedgerId) throws IOException {
        ArrayList<Iterable<Long>> listIt = new ArrayList<Iterable<Long>>(this.numberOfDirs);
        for (SingleDirectoryDbLedgerStorage ls : this.ledgerStorageList) {
            listIt.add(ls.getActiveLedgersInRange(firstLedgerId, lastLedgerId));
        }
        return Iterables.concat(listIt);
    }

    public ByteBuf getLastEntry(long ledgerId) throws IOException, BookieException {
        return this.getLedgerStorage(ledgerId).getLastEntry(ledgerId);
    }

    @VisibleForTesting
    boolean isFlushRequired() {
        return this.ledgerStorageList.stream().allMatch(SingleDirectoryDbLedgerStorage::isFlushRequired);
    }

    @VisibleForTesting
    public List<SingleDirectoryDbLedgerStorage> getLedgerStorageList() {
        return this.ledgerStorageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLedgerIndexEntries(long ledgerId, ServerConfiguration serverConf, SingleDirectoryDbLedgerStorage.LedgerLoggerProcessor processor) throws IOException {
        LedgerDirsManager ledgerDirsManager;
        Preconditions.checkNotNull((Object)((Object)serverConf), (Object)"ServerConfiguration can't be null");
        Preconditions.checkNotNull((Object)processor, (Object)"LedgerLoggger info processor can't null");
        DiskChecker diskChecker = new DiskChecker(serverConf.getDiskUsageThreshold(), serverConf.getDiskUsageWarnThreshold());
        LedgerDirsManager indexDirsManager = ledgerDirsManager = new LedgerDirsManager(serverConf, serverConf.getLedgerDirs(), diskChecker);
        File[] idxDirs = serverConf.getIndexDirs();
        if (null != idxDirs) {
            indexDirsManager = new LedgerDirsManager(serverConf, idxDirs, diskChecker);
        }
        List<File> ledgerDirs = ledgerDirsManager.getAllLedgerDirs();
        List<File> indexDirs = indexDirsManager.getAllLedgerDirs();
        if (ledgerDirs.size() != indexDirs.size()) {
            throw new IOException("ledger and index dirs size not matched");
        }
        int dirIndex = MathUtils.signSafeMod((long)ledgerId, (int)ledgerDirs.size());
        String indexBasePath = indexDirs.get(dirIndex).toString();
        try (EntryLocationIndex entryLocationIndex = new EntryLocationIndex(serverConf, (basePath, subPath, dbConfigType, conf1) -> new KeyValueStorageRocksDB(basePath, subPath, KeyValueStorageFactory.DbConfigType.Default, conf1, true), indexBasePath, (StatsLogger)NullStatsLogger.INSTANCE);){
            long lastEntryId = entryLocationIndex.getLastEntryInLedger(ledgerId);
            for (long currentEntry = 0L; currentEntry <= lastEntryId; ++currentEntry) {
                long offset = entryLocationIndex.getLocation(ledgerId, currentEntry);
                if (offset <= 0L) continue;
                long entryLogId = offset >> 32;
                long position = offset & 0xFFFFFFFFL;
                processor.process(currentEntry, entryLogId, position);
            }
        }
    }

    @Override
    public void forceGC() {
        this.ledgerStorageList.stream().forEach(SingleDirectoryDbLedgerStorage::forceGC);
    }

    @Override
    public void forceGC(boolean forceMajor, boolean forceMinor) {
        this.ledgerStorageList.stream().forEach(s -> s.forceGC(forceMajor, forceMinor));
    }

    @Override
    public boolean isInForceGC() {
        return this.ledgerStorageList.stream().anyMatch(SingleDirectoryDbLedgerStorage::isInForceGC);
    }

    @Override
    public void suspendMinorGC() {
        this.ledgerStorageList.stream().forEach(SingleDirectoryDbLedgerStorage::suspendMinorGC);
    }

    @Override
    public void suspendMajorGC() {
        this.ledgerStorageList.stream().forEach(SingleDirectoryDbLedgerStorage::suspendMajorGC);
    }

    @Override
    public void resumeMinorGC() {
        this.ledgerStorageList.stream().forEach(SingleDirectoryDbLedgerStorage::resumeMinorGC);
    }

    @Override
    public void resumeMajorGC() {
        this.ledgerStorageList.stream().forEach(SingleDirectoryDbLedgerStorage::resumeMajorGC);
    }

    @Override
    public boolean isMajorGcSuspended() {
        return this.ledgerStorageList.stream().allMatch(SingleDirectoryDbLedgerStorage::isMajorGcSuspended);
    }

    @Override
    public boolean isMinorGcSuspended() {
        return this.ledgerStorageList.stream().allMatch(SingleDirectoryDbLedgerStorage::isMinorGcSuspended);
    }

    @Override
    public void entryLocationCompact() {
        this.ledgerStorageList.forEach(SingleDirectoryDbLedgerStorage::entryLocationCompact);
    }

    @Override
    public void entryLocationCompact(List<String> locations) {
        for (SingleDirectoryDbLedgerStorage ledgerStorage : this.ledgerStorageList) {
            String entryLocation = ledgerStorage.getEntryLocationDBPath().get(0);
            if (!locations.contains(entryLocation)) continue;
            ledgerStorage.entryLocationCompact();
        }
    }

    @Override
    public boolean isEntryLocationCompacting() {
        return this.ledgerStorageList.stream().anyMatch(SingleDirectoryDbLedgerStorage::isEntryLocationCompacting);
    }

    @Override
    public Map<String, Boolean> isEntryLocationCompacting(List<String> locations) {
        HashMap isCompacting = Maps.newHashMap();
        for (SingleDirectoryDbLedgerStorage ledgerStorage : this.ledgerStorageList) {
            String entryLocation = ledgerStorage.getEntryLocationDBPath().get(0);
            if (!locations.contains(entryLocation)) continue;
            isCompacting.put(entryLocation, ledgerStorage.isEntryLocationCompacting());
        }
        return isCompacting;
    }

    @Override
    public List<String> getEntryLocationDBPath() {
        ArrayList allEntryLocationDBPath = Lists.newArrayList();
        for (SingleDirectoryDbLedgerStorage ledgerStorage : this.ledgerStorageList) {
            allEntryLocationDBPath.addAll(ledgerStorage.getEntryLocationDBPath());
        }
        return allEntryLocationDBPath;
    }

    @Override
    public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        return this.ledgerStorageList.stream().map(single -> single.getGarbageCollectionStatus().get(0)).collect(Collectors.toList());
    }

    static long getLongVariableOrDefault(ServerConfiguration conf, String keyName, long defaultValue) {
        Object obj = conf.getProperty(keyName);
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj == null) {
            return defaultValue;
        }
        if (StringUtils.isEmpty((CharSequence)conf.getString(keyName))) {
            return defaultValue;
        }
        return conf.getLong(keyName);
    }

    static boolean getBooleanVariableOrDefault(ServerConfiguration conf, String keyName, boolean defaultValue) {
        Object obj = conf.getProperty(keyName);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj == null) {
            return defaultValue;
        }
        if (StringUtils.isEmpty((CharSequence)conf.getString(keyName))) {
            return defaultValue;
        }
        return conf.getBoolean(keyName);
    }

    @Override
    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long ledgerId) throws IOException {
        throw new UnsupportedOperationException("getListOfEntriesOfLedger method is currently unsupported for DbLedgerStorage");
    }

    @Override
    public void setLimboState(long ledgerId) throws IOException {
        this.getLedgerStorage(ledgerId).setLimboState(ledgerId);
    }

    @Override
    public boolean hasLimboState(long ledgerId) throws IOException {
        return this.getLedgerStorage(ledgerId).hasLimboState(ledgerId);
    }

    @Override
    public void clearLimboState(long ledgerId) throws IOException {
        this.getLedgerStorage(ledgerId).clearLimboState(ledgerId);
    }

    @Override
    public EnumSet<LedgerStorage.StorageState> getStorageStateFlags() throws IOException {
        return this.getLedgerStorage(0L).getStorageStateFlags();
    }

    @Override
    public void setStorageStateFlag(LedgerStorage.StorageState flag) throws IOException {
        this.getLedgerStorage(0L).setStorageStateFlag(flag);
    }

    @Override
    public void clearStorageStateFlag(LedgerStorage.StorageState flag) throws IOException {
        this.getLedgerStorage(0L).clearStorageStateFlag(flag);
    }
}

