/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforceAuthenticationTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(EnforceAuthenticationTest.class);
    private QuorumPeerTestBase.Servers servers;
    private int clientPort;

    @Before
    public void setUp() {
        System.setProperty("zookeeper.admin.enableServer", "false");
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        System.clearProperty("zookeeper.enforce.auth.enabled");
        System.clearProperty("zookeeper.enforce.auth.schemes");
    }

    @Override
    @After
    public void tearDown() throws InterruptedException {
        if (this.servers != null) {
            this.servers.shutDownAllServers();
        }
        System.clearProperty("zookeeper.enforce.auth.enabled");
        System.clearProperty("zookeeper.enforce.auth.schemes");
    }

    @Test
    public void testEnforceAuthenticationOldBehaviour() throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        this.startServer(prop);
        this.testEnforceAuthOldBehaviour(false);
    }

    @Test
    public void testEnforceAuthenticationOldBehaviourWithNetty() throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.enabled"), "false");
        prop.put("serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        this.startServer(prop);
        this.testEnforceAuthOldBehaviour(true);
    }

    private void testEnforceAuthOldBehaviour(boolean netty) throws Exception {
        ZKClientConfig config = new ZKClientConfig();
        if (netty) {
            config.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        }
        ZooKeeper client = ClientBase.createZKClient("127.0.0.1:" + this.clientPort, ClientBase.CONNECTION_TIMEOUT, ClientBase.CONNECTION_TIMEOUT, config);
        String path = "/defaultAuth" + System.currentTimeMillis();
        String data = "someData";
        client.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] data1 = client.getData(path, false, null);
        Assert.assertEquals((Object)data, (Object)new String(data1));
        client.close();
    }

    @Test
    public void testServerStartShouldFailWhenEnforceAuthSchemeIsNotConfigured() throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.enabled"), "true");
        this.testServerCannotStart(prop);
    }

    @Test
    public void testServerStartShouldFailWhenAuthProviderIsNotConfigured() throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.enabled"), "true");
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.schemes"), "sasl");
        this.testServerCannotStart(prop);
    }

    private void testServerCannotStart(Map<String, String> prop) throws Exception {
        File confFile = this.getConfFile(prop);
        ServerConfig config = new ServerConfig();
        config.parse(confFile.toString());
        ZooKeeperServerMain serverMain = new ZooKeeperServerMain();
        try {
            serverMain.runFromConfig(config);
            Assert.fail((String)"IllegalArgumentException is expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEnforceAuthenticationNewBehaviour() throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.enabled"), "true");
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.schemes"), "digest");
        this.startServer(prop);
        this.testEnforceAuthNewBehaviour(false);
    }

    @Test
    public void testEnforceAuthenticationNewBehaviourWithNetty() throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.enabled"), "true");
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.schemes"), "digest");
        prop.put("serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        this.startServer(prop);
        this.testEnforceAuthNewBehaviour(true);
    }

    private void testEnforceAuthNewBehaviour(boolean netty) throws Exception {
        ZKClientConfig config = new ZKClientConfig();
        if (netty) {
            config.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ZooKeeper client = new ZooKeeper("127.0.0.1:" + this.clientPort, ClientBase.CONNECTION_TIMEOUT, this.getWatcher(countDownLatch), config);
        countDownLatch.await();
        String path = "/newAuth" + System.currentTimeMillis();
        String data = "someData";
        try {
            client.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assert.fail((String)"SessionClosedRequireAuthException is expected.");
        }
        catch (KeeperException.SessionClosedRequireAuthException sessionClosedRequireAuthException) {
            // empty catch block
        }
        client.close();
        countDownLatch = new CountDownLatch(1);
        client = new ZooKeeper("127.0.0.1:" + this.clientPort, ClientBase.CONNECTION_TIMEOUT, this.getWatcher(countDownLatch), config);
        countDownLatch.await();
        String idPassword = "user1:pass1";
        client.addAuthInfo("digest", idPassword.getBytes());
        client.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] data1 = client.getData(path, false, null);
        Assert.assertEquals((Object)data, (Object)new String(data1));
        client.close();
    }

    @Test
    public void testEnforceAuthenticationWithMultipleAuthSchemes() throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.enabled"), "true");
        prop.put(this.removeZooKeeper("zookeeper.enforce.auth.schemes"), "digest,ip");
        this.startServer(prop);
        ZKClientConfig config = new ZKClientConfig();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ZooKeeper client = new ZooKeeper("127.0.0.1:" + this.clientPort, ClientBase.CONNECTION_TIMEOUT, this.getWatcher(countDownLatch), config);
        countDownLatch.await();
        String path = "/newAuth" + System.currentTimeMillis();
        String data = "someData";
        client.create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        byte[] data1 = client.getData(path, false, null);
        Assert.assertEquals((Object)data, (Object)new String(data1));
        client.close();
    }

    private String removeZooKeeper(String prop) {
        return prop.replace("zookeeper.", "");
    }

    private File getConfFile(Map<String, String> additionalProp) throws IOException {
        this.clientPort = PortAssignment.unique();
        StringBuilder sb = new StringBuilder();
        sb.append("standaloneEnabled=true\n");
        if (null != additionalProp) {
            for (Map.Entry<String, String> entry : additionalProp.entrySet()) {
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(entry.getValue());
                sb.append("\n");
            }
        }
        String currentQuorumCfgSection = sb.toString();
        return new QuorumPeerTestBase.MainThread(1, this.clientPort, currentQuorumCfgSection, false).getConfFile();
    }

    private void startServer(Map<String, String> additionalProp) throws Exception {
        additionalProp.put("standaloneEnabled", "true");
        this.servers = this.LaunchServers(1, additionalProp);
        this.clientPort = this.servers.clientPorts[0];
    }

    private Watcher getWatcher(CountDownLatch countDownLatch) {
        return event -> {
            Watcher.Event.EventType type = event.getType();
            if (type == Watcher.Event.EventType.None) {
                Watcher.Event.KeeperState state = event.getState();
                if (state == Watcher.Event.KeeperState.SyncConnected) {
                    LOG.info("Event.KeeperState.SyncConnected");
                    countDownLatch.countDown();
                } else if (state == Watcher.Event.KeeperState.Expired) {
                    LOG.info("Event.KeeperState.Expired");
                } else if (state == Watcher.Event.KeeperState.Disconnected) {
                    LOG.info("Event.KeeperState.Disconnected");
                } else if (state == Watcher.Event.KeeperState.AuthFailed) {
                    LOG.info("Event.KeeperState.AuthFailed");
                }
            }
        };
    }
}

