/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.util.ServiceUtils;
import org.hamcrest.CustomMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKTestCase {
    protected static final File testBaseDir = new File(System.getProperty("build.test.dir", "build"));
    private static final Logger LOG = LoggerFactory.getLogger(ZKTestCase.class);
    public static final int DEFAULT_METRIC_TIMEOUT = 30;
    private String testName;

    protected String getTestName() {
        return this.testName;
    }

    public void syncClient(ZooKeeper zk, boolean synchronous) throws KeeperException {
        if (synchronous) {
            try {
                zk.sync("/");
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return;
        }
        CompletableFuture synced = new CompletableFuture();
        zk.sync("/", (rc, path, ctx) -> synced.complete(KeeperException.Code.get((int)rc)), null);
        KeeperException.Code code = (KeeperException.Code)synced.join();
        if (code != KeeperException.Code.OK) {
            throw KeeperException.create((KeeperException.Code)code);
        }
    }

    @BeforeAll
    public static void before() {
        if (!testBaseDir.exists()) {
            Assertions.assertTrue((boolean)testBaseDir.mkdirs(), (String)("Cannot properly create test base directory " + testBaseDir.getAbsolutePath()));
        } else if (!testBaseDir.isDirectory()) {
            Assertions.assertTrue((boolean)testBaseDir.delete(), (String)("Cannot properly delete file with duplicate name of test base directory " + testBaseDir.getAbsolutePath()));
            Assertions.assertTrue((boolean)testBaseDir.mkdirs(), (String)("Cannot properly create test base directory " + testBaseDir.getAbsolutePath()));
        }
    }

    @BeforeEach
    public void starting(TestInfo testInfo) {
        System.setProperty("zookeeper.admin.enableServer", "false");
        System.setProperty("zookeeper.admin.rateLimiterIntervalInMS", "0");
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        LOG.info("STARTING {}", (Object)testInfo.getTestMethod());
    }

    @AfterEach
    public void finished(TestInfo testInfo) {
        LOG.info("FINISHED {}", (Object)testInfo.getTestMethod());
    }

    public static void waitFor(String msg, WaitForCondition condition, int timeout) throws InterruptedException {
        Instant deadline = Instant.now().plusSeconds(timeout);
        while (Instant.now().isBefore(deadline)) {
            if (condition.evaluate()) {
                return;
            }
            Thread.sleep(100L);
        }
        Assertions.fail((String)msg);
    }

    public static <T> void waitForMetric(String metricKey, Matcher<T> matcher) throws InterruptedException {
        ZKTestCase.waitForMetric(metricKey, matcher, 30);
    }

    public static <T> void waitForMetric(String metricKey, Matcher<T> matcher, int timeoutInSeconds) throws InterruptedException {
        String errorMessage = String.format("metric \"%s\" failed to match after %d seconds", metricKey, timeoutInSeconds);
        ZKTestCase.waitFor(errorMessage, () -> {
            Object actual = MetricsUtils.currentServerMetrics().get(metricKey);
            if (!matcher.matches(actual)) {
                StringDescription description = new StringDescription();
                matcher.describeMismatch(actual, (Description)description);
                LOG.info("match failed for metric {}: {}", (Object)metricKey, (Object)description);
                return false;
            }
            return true;
        }, timeoutInSeconds);
    }

    public static Matcher<Number> closeTo(final double operand, final double error) {
        return new CustomMatcher<Number>(String.format("A number within %s of %s", error, operand)){

            public boolean matches(Object actual) {
                return Math.abs(operand - ((Number)actual).doubleValue()) <= error;
            }
        };
    }

    static {
        ServiceUtils.setSystemExitProcedure((Consumer)ServiceUtils.LOG_ONLY);
    }

    public static interface WaitForCondition {
        public boolean evaluate();
    }
}

