/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.CompletionKey;
import org.apache.bookkeeper.proto.CompletionValue;
import org.apache.bookkeeper.proto.PerChannelBookieClient;

class StartTLSCompletion
extends CompletionValue {
    final BookkeeperInternalCallbacks.StartTLSCallback cb;

    public StartTLSCompletion(final CompletionKey key, PerChannelBookieClient perChannelBookieClient) {
        super("StartTLS", null, -1L, -1L, perChannelBookieClient);
        this.opLogger = perChannelBookieClient.startTLSOpLogger;
        this.timeoutOpLogger = perChannelBookieClient.startTLSTimeoutOpLogger;
        this.cb = new BookkeeperInternalCallbacks.StartTLSCallback(){

            @Override
            public void startTLSComplete(int rc, Object ctx) {
                StartTLSCompletion.this.logOpResult(rc);
                key.release();
            }
        };
    }

    @Override
    public void errorOut() {
        this.errorOut(-8);
    }

    @Override
    public void errorOut(int rc) {
        this.perChannelBookieClient.failTLS(rc);
    }

    @Override
    public void handleV3Response(BookkeeperProtocol.Response response) {
        BookkeeperProtocol.StatusCode status = response.getStatus();
        if (LOG.isDebugEnabled()) {
            this.logResponse(status, new Object[0]);
        }
        int rc = this.convertStatus(status, -24);
        this.cb.startTLSComplete(rc, null);
        if (this.perChannelBookieClient.state != PerChannelBookieClient.ConnectionState.START_TLS) {
            LOG.error("Connection state changed before TLS response received");
            this.perChannelBookieClient.failTLS(-8);
        } else if (status != BookkeeperProtocol.StatusCode.EOK) {
            LOG.error("Client received error {} during TLS negotiation", (Object)status);
            this.perChannelBookieClient.failTLS(-24);
        } else {
            this.perChannelBookieClient.initTLSHandshake();
        }
    }
}

