/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.HashSet;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.DumbWatcher;
import org.apache.zookeeper.server.util.BitHashSet;
import org.apache.zookeeper.server.watch.WatcherOrBitSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WatcherOrBitSetTest
extends ZKTestCase {
    @Test
    public void testWatcherSet() {
        HashSet<DumbWatcher> wset = new HashSet<DumbWatcher>();
        WatcherOrBitSet hashSet = new WatcherOrBitSet(wset);
        Assertions.assertEquals((int)0, (int)hashSet.size());
        DumbWatcher w1 = new DumbWatcher();
        Assertions.assertFalse((boolean)hashSet.contains((Watcher)w1));
        wset.add(w1);
        Assertions.assertTrue((boolean)hashSet.contains((Watcher)w1));
        Assertions.assertEquals((int)1, (int)hashSet.size());
        Assertions.assertFalse((boolean)hashSet.contains(1));
    }

    @Test
    public void testBitSet() {
        BitHashSet bset = new BitHashSet(0);
        WatcherOrBitSet bitSet = new WatcherOrBitSet(bset);
        Assertions.assertEquals((int)0, (int)bitSet.size());
        Integer bit = 1;
        Assertions.assertFalse((boolean)bitSet.contains(1));
        Assertions.assertFalse((boolean)bitSet.contains(bit.intValue()));
        bset.add(bit);
        Assertions.assertTrue((boolean)bitSet.contains(1));
        Assertions.assertTrue((boolean)bitSet.contains(bit.intValue()));
        Assertions.assertEquals((int)1, (int)bitSet.size());
    }
}

