/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import org.apache.zookeeper.server.util.CircularBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CircularBufferTest {
    @Test
    public void testCircularBuffer() {
        int capacity = 3;
        CircularBuffer buffer = new CircularBuffer(String.class, 3);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"A");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"B");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"C");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"A", (Object)buffer.take());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"B", (Object)buffer.take());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"C", (Object)buffer.take());
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"1");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"2");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"3");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"4");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"2", (Object)buffer.take());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"3", (Object)buffer.take());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"4", (Object)buffer.take());
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"a");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"b");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"c");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"d");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"e");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"f");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"g");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"e", (Object)buffer.take());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"f", (Object)buffer.take());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"g", (Object)buffer.take());
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testCircularBufferWithCapacity1() {
        boolean capacity = true;
        CircularBuffer buffer = new CircularBuffer(String.class, 1);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"A");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        buffer.write((Object)"B");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertTrue((boolean)buffer.isFull());
        Assertions.assertEquals((Object)"B", (Object)buffer.take());
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
    }

    @Test
    public void testCircularBufferReset() {
        int capacity = 3;
        CircularBuffer buffer = new CircularBuffer(String.class, 3);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        buffer.write((Object)"A");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((int)1, (int)buffer.size());
        Assertions.assertEquals((Object)"A", (Object)buffer.peek());
        buffer.write((Object)"B");
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((int)2, (int)buffer.size());
        Assertions.assertEquals((Object)"A", (Object)buffer.peek());
        buffer.reset();
        Assertions.assertNull((Object)buffer.peek());
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        Assertions.assertEquals((int)0, (int)buffer.size());
    }

    @Test
    public void testCircularBufferIllegalCapacity() {
        try {
            CircularBuffer buffer = new CircularBuffer(String.class, 0);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"CircularBuffer capacity should be greater than 0", (Object)e.getMessage());
        }
    }
}

