/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.security.sasl.SaslException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerListener;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerRequestProcessor;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class DIFFSyncTest
extends QuorumPeerTestBase {
    private static final int SERVER_COUNT = 3;
    private static final String PATH_PREFIX = "/test_";
    private int[] clientPorts;
    private QuorumPeerTestBase.MainThread[] mt;
    private ZooKeeper[] zkClients;

    @BeforeEach
    public void start() throws Exception {
        this.clientPorts = new int[3];
        this.mt = this.startQuorum(this.clientPorts);
        this.zkClients = new ZooKeeper[3];
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        for (ZooKeeper zooKeeper : this.zkClients) {
            try {
                if (zooKeeper == null) continue;
                zooKeeper.close();
            }
            catch (InterruptedException e) {
                LOG.warn("ZooKeeper interrupted while shutting it down", (Throwable)e);
            }
        }
        for (QuorumPeerTestBase.MainThread mainThread : this.mt) {
            try {
                mainThread.shutdown();
            }
            catch (InterruptedException e) {
                LOG.warn("Quorum Peer interrupted while shutting it down", (Throwable)e);
            }
        }
    }

    @Test
    @Timeout(value=120L)
    public void testTxnLoss_FailToPersistAndCommitTxns() throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        Assertions.assertEquals((long)2L, (long)this.mt[2].getQuorumPeer().getLeaderId());
        this.createZKClient(2);
        paths.add(this.createNode(this.zkClients[2], "/test_0"));
        this.mt[0].shutdown();
        LOG.info("S0 shutdown.");
        paths.add(this.createNode(this.zkClients[2], "/test_1"));
        this.logEpochsAndLastLoggedTxnForAllServers();
        this.mt[1].shutdown();
        LOG.info("S1 shutdown.");
        this.mt[0].start(new MockTestQPMain());
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts[0], ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 0 being up");
        LOG.info("S0 restarted.");
        this.logEpochsAndLastLoggedTxnForAllServers();
        Assertions.assertEquals((long)2L, (long)this.mt[2].getQuorumPeer().getLeaderId());
        this.mt[2].shutdown();
        LOG.info("S2 shutdown.");
        this.mt[1].start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts[1], ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 1 being up");
        LOG.info("S1 restarted.");
        this.logEpochsAndLastLoggedTxnForAllServers();
        Assertions.assertEquals((long)0L, (long)this.mt[0].getQuorumPeer().getLeaderId());
        this.createZKClient(0);
        paths.add(this.createNode(this.zkClients[0], "/test_3"));
        this.mt[2].start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts[2], ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 2 being up");
        LOG.info("S2 restarted.");
        this.logEpochsAndLastLoggedTxnForAllServers();
        this.validateDataFromAllClients(paths);
    }

    @Test
    @Timeout(value=120L)
    public void testLeaderShutdown_AckProposalBeforeAckNewLeader() throws Exception {
        Assertions.assertEquals((long)2L, (long)this.mt[2].getQuorumPeer().getLeaderId());
        this.createZKClient(2);
        this.createNode(this.zkClients[2], "/test_0");
        this.mt[0].shutdown();
        LOG.info("S0 shutdown.");
        this.createNode(this.zkClients[2], "/test_1");
        this.logEpochsAndLastLoggedTxnForAllServers();
        this.mt[1].shutdown();
        LOG.info("S1 shutdown.");
        this.mt[0].start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts[0], ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 0 being up");
        LOG.info("S0 restarted.");
        this.createNode(this.zkClients[2], "/test_2");
        for (int i = 0; i < 3; ++i) {
            if (i == 1) continue;
            QuorumPeer qp = this.mt[i].getQuorumPeer();
            Assertions.assertNotNull((Object)qp);
            Assertions.assertEquals((long)2L, (long)qp.getCurrentEpoch());
            Assertions.assertEquals((long)2L, (long)qp.getAcceptedEpoch());
            Assertions.assertEquals((Object)"200000001", (Object)Long.toHexString(qp.getLastLoggedZxid()));
        }
    }

    private QuorumPeerTestBase.MainThread[] startQuorum(int[] clientPorts) throws IOException {
        int i;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server);
            sb.append("\n");
        }
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], sb.toString(), false);
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
        }
        return mt;
    }

    private void createZKClient(int idx) throws Exception {
        this.zkClients[idx] = null;
        ClientBase.CountdownWatcher watch = new ClientBase.CountdownWatcher();
        this.zkClients[idx] = new ZooKeeper("127.0.0.1:" + this.clientPorts[idx], ClientBase.CONNECTION_TIMEOUT, (Watcher)watch);
        watch.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
    }

    private String createNode(ZooKeeper zk, String path) throws Exception {
        String fullPath = zk.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertNotNull((Object)zk.exists(path, false));
        return fullPath;
    }

    private void logEpochsAndLastLoggedTxnForAllServers() throws Exception {
        for (int i = 0; i < 3; ++i) {
            QuorumPeer qp = this.mt[i].getQuorumPeer();
            if (qp == null) continue;
            LOG.info(String.format("server id=%d, acceptedEpoch=%d, currentEpoch=%d, lastLoggedTxn=%s", qp.getMyId(), qp.getAcceptedEpoch(), qp.getCurrentEpoch(), Long.toHexString(qp.getLastLoggedZxid())));
        }
    }

    private void validateDataFromAllClients(List<String> paths) throws Exception {
        for (int i = 0; i < 3; ++i) {
            if (this.zkClients[i] == null) {
                this.createZKClient(i);
            }
            for (String path : paths) {
                Assertions.assertNotNull((Object)this.zkClients[i].exists(path, false), (String)("znode " + path + " is missing"));
            }
            Assertions.assertEquals((int)3, (int)paths.size());
        }
    }

    private static class MockCommitProcessor
    extends CommitProcessor {
        public MockCommitProcessor(RequestProcessor nextProcessor, String id, boolean matchSyncs, ZooKeeperServerListener listener) {
            super(nextProcessor, id, matchSyncs, listener);
        }

        public void commit(Request request) {
            QuorumPeerTestBase.LOG.info("Commit request for zxid {} is dropped", (Object)Long.toHexString(request.getHdr().getZxid()));
        }
    }

    private static class MockSyncRequestProcessor
    extends SyncRequestProcessor {
        public MockSyncRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
            super(zks, nextProcessor);
        }

        public void processRequest(Request request) {
            QuorumPeerTestBase.LOG.info("Sync request for zxid {} is dropped", (Object)Long.toHexString(request.getHdr().getZxid()));
        }
    }

    private static class TestQuorumPeer
    extends QuorumPeer {
        protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
            FollowerZooKeeperServer followerZookeeperServer = new FollowerZooKeeperServer(logFactory, this, this.getZkDb()){

                protected void setupRequestProcessors() {
                    FinalRequestProcessor finalProcessor = new FinalRequestProcessor((ZooKeeperServer)this);
                    this.commitProcessor = new MockCommitProcessor((RequestProcessor)finalProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
                    this.commitProcessor.start();
                    this.firstProcessor = new FollowerRequestProcessor((FollowerZooKeeperServer)this, (RequestProcessor)this.commitProcessor);
                    ((FollowerRequestProcessor)this.firstProcessor).start();
                    this.syncProcessor = new MockSyncRequestProcessor((ZooKeeperServer)this, (RequestProcessor)new SendAckRequestProcessor((Learner)this.getFollower()));
                    this.syncProcessor.start();
                }
            };
            return new Follower((QuorumPeer)this, followerZookeeperServer);
        }
    }

    private static class MockTestQPMain
    extends QuorumPeerTestBase.TestQPMain {
        private MockTestQPMain() {
        }

        protected QuorumPeer getQuorumPeer() throws SaslException {
            return new TestQuorumPeer();
        }
    }
}

