/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.table;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.AdminCommand;
import org.apache.bookkeeper.stream.proto.StorageType;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class GetTableCommand
extends AdminCommand<Flags> {
    private static final String NAME = "get";
    private static final String DESC = "Get the details of a table";

    public GetTableCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<table-name>").build());
    }

    @Override
    protected void run(StorageAdminClient admin, BKFlags globalFlags, Flags flags) throws Exception {
        Preconditions.checkArgument((!flags.arguments.isEmpty() ? 1 : 0) != 0, (Object)"Table name is not provided");
        String streamName = (String)flags.arguments.get(0);
        try {
            StreamProperties streamProps = (StreamProperties)FutureUtils.result((CompletableFuture)admin.getStream(globalFlags.namespace, streamName));
            if (streamProps.getStreamConf().getStorageType() != StorageType.TABLE) {
                this.spec.console().println("'" + streamName + "' is not a table storage entity, its storage type is " + streamProps.getStreamConf().getStorageType());
            } else {
                this.spec.console().println("Table '" + streamName + "' :");
            }
            this.spec.console().println(streamProps);
        }
        catch (NamespaceNotFoundException nfe) {
            this.spec.console().println("Namespace '" + globalFlags.namespace + "' does not exist");
        }
        catch (StreamNotFoundException snfe) {
            this.spec.console().println("Table '" + streamName + "' does not exist");
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

