/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOperationTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultiOperationTest.class);
    private ZooKeeper zk;
    private ZooKeeper zk_chroot;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        SyncRequestProcessor.setSnapCount((int)150);
        super.setUp();
        this.zk = this.createClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpResult> multi(ZooKeeper zk, Iterable<Op> ops, boolean useAsync) throws KeeperException, InterruptedException {
        if (useAsync) {
            final MultiResult res = new MultiResult();
            zk.multi(ops, new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    if (!ClientCnxn.isInEventThread()) {
                        throw new RuntimeException("not in event thread");
                    }
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            if (KeeperException.Code.OK.intValue() != res.rc && ops.iterator().next().getKind() != Op.OpKind.READ) {
                KeeperException ke = KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)res.rc));
                throw ke;
            }
            return res.results;
        }
        return zk.multi(ops);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void multiHavingErrors(ZooKeeper zk, Iterable<Op> ops, List<Integer> expectedResultCodes, String expectedErr, boolean useAsync) throws KeeperException, InterruptedException {
        if (useAsync) {
            final MultiResult res = new MultiResult();
            zk.multi(ops, new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            for (int i = 0; i < res.results.size(); ++i) {
                OpResult opResult = res.results.get(i);
                Assertions.assertTrue((boolean)(opResult instanceof OpResult.ErrorResult), (String)"Did't receive proper error response");
                OpResult.ErrorResult errRes = (OpResult.ErrorResult)opResult;
                Assertions.assertEquals((int)expectedResultCodes.get(i), (int)errRes.getErr(), (String)"Did't receive proper error code");
            }
        } else {
            try {
                zk.multi(ops);
                Assertions.fail((String)"Shouldn't have validated in ZooKeeper client!");
            }
            catch (KeeperException e) {
                Assertions.assertEquals((Object)expectedErr, (Object)e.code().name(), (String)"Wrong exception");
            }
            catch (IllegalArgumentException e) {
                Assertions.assertEquals((Object)expectedErr, (Object)e.getMessage(), (String)"Wrong exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpResult> commit(Transaction txn, boolean useAsync) throws KeeperException, InterruptedException {
        if (useAsync) {
            final MultiResult res = new MultiResult();
            txn.commit(new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            if (KeeperException.Code.OK.intValue() != res.rc) {
                KeeperException ke = KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)res.rc));
                throw ke;
            }
            return res.results;
        }
        return txn.commit();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testInvalidPath(boolean useAsync) throws Exception {
        ArrayList<Integer> expectedResultCodes = new ArrayList<Integer>();
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        List<Op> opList = Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1/", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        String expectedErr = "Path must not end with / character";
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr, useAsync);
        opList = Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"multi1/", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (int)CreateMode.EPHEMERAL_SEQUENTIAL.toFlag()), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        expectedErr = "Path must start with / character";
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr, useAsync);
        opList = Arrays.asList(Op.check((String)"/multi0", (int)-1), Op.check((String)"/multi1/", (int)100), Op.check((String)"/multi2", (int)5));
        expectedErr = "Path must not end with / character";
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr, useAsync);
        opList = Arrays.asList(Op.delete((String)"/multi0", (int)-1), Op.delete((String)"/multi1/", (int)100), Op.delete((String)"/multi2", (int)5));
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr, useAsync);
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        opList = Arrays.asList(Op.setData((String)"/multi0", (byte[])new byte[0], (int)-1), Op.setData((String)"/multi1/", (byte[])new byte[0], (int)-1), Op.setData((String)"/multi2", (byte[])new byte[0], (int)-1), Op.setData((String)"multi3", (byte[])new byte[0], (int)-1));
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr, useAsync);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiRollback(boolean useAsync) throws Exception {
        this.zk.create("/foo", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        TestableZooKeeper epheZk = this.createClient();
        epheZk.create("/foo/bar", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        List<Op> opList = Arrays.asList(Op.delete((String)"/foo", (int)-1));
        try {
            this.zk.multi(opList);
            Assertions.fail((String)"multi delete should failed for not empty directory");
        }
        catch (KeeperException.NotEmptyException notEmptyException) {
            // empty catch block
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.zk.exists("/foo/bar", event -> {
            if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
                latch.countDown();
            }
        });
        epheZk.close();
        latch.await();
        try {
            this.zk.getData("/foo/bar", false, null);
            Assertions.fail((String)"ephemeral node should have been deleted");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        this.zk.multi(opList);
        try {
            this.zk.getData("/foo", false, null);
            Assertions.fail((String)"persistent node should have been deleted after multi");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testBlankPath(boolean useAsync) throws Exception {
        ArrayList<Integer> expectedResultCodes = new ArrayList<Integer>();
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        String expectedErr = "Path cannot be null";
        List<Op> opList = Arrays.asList(Op.delete((String)"/multi0", (int)-1), Op.delete(null, (int)100), Op.delete((String)"/multi2", (int)5), Op.delete((String)"", (int)-1));
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr, useAsync);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    @Timeout(value=90L)
    public void testInvalidCreateModeFlag(boolean useAsync) throws Exception {
        ArrayList<Integer> expectedResultCodes = new ArrayList<Integer>();
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        expectedResultCodes.add(KeeperException.Code.BADARGUMENTS.intValue());
        expectedResultCodes.add(KeeperException.Code.RUNTIMEINCONSISTENCY.intValue());
        int createModeFlag = 6789;
        List<Op> opList = Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (int)createModeFlag), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        String expectedErr = KeeperException.Code.BADARGUMENTS.name();
        this.multiHavingErrors(this.zk, opList, expectedResultCodes, expectedErr, useAsync);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testChRootCreateDelete(boolean useAsync) throws Exception {
        String chRoot = this.createNameSpace(useAsync);
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        Op createChild = Op.create((String)"/myid", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        this.multi(this.zk_chroot, Arrays.asList(createChild), useAsync);
        Assertions.assertNotNull((Object)this.zk.exists(chRoot + "/myid", false), (String)("zNode is not created under chroot:" + chRoot));
        Assertions.assertNotNull((Object)this.zk_chroot.exists("/myid", false), (String)("zNode is not created under chroot:" + chRoot));
        Assertions.assertNull((Object)this.zk.exists("/myid", false), (String)"zNode is created directly under '/', ignored configured chroot");
        Op deleteChild = Op.delete((String)"/myid", (int)0);
        this.multi(this.zk_chroot, Arrays.asList(deleteChild), useAsync);
        Assertions.assertNull((Object)this.zk.exists(chRoot + "/myid", false), (String)("zNode exists under chroot:" + chRoot));
        Assertions.assertNull((Object)this.zk_chroot.exists("/myid", false), (String)("zNode exists under chroot:" + chRoot));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testChRootSetData(boolean useAsync) throws Exception {
        int i;
        String chRoot = this.createNameSpace(useAsync);
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.create((String)names[i], (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            ops.add(Op.setData((String)names[i], (byte[])names[i].getBytes(), (int)0));
        }
        this.multi(this.zk_chroot, ops, useAsync);
        for (i = 0; i < names.length; ++i) {
            Assertions.assertArrayEquals((byte[])names[i].getBytes(), (byte[])this.zk_chroot.getData(names[i], false, null), (String)"zNode data not matching");
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testChRootCheck(boolean useAsync) throws Exception {
        int i;
        String chRoot = this.createNameSpace(useAsync);
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            this.zk.create(chRoot + names[i], new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.check((String)names[i], (int)0));
        }
        this.multi(this.zk_chroot, ops, useAsync);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testChRootTransaction(boolean useAsync) throws Exception {
        String chRoot = this.createNameSpace(useAsync);
        this.zk_chroot = this.createClient(this.hostPort + chRoot);
        String childPath = "/myid";
        Transaction transaction = this.zk_chroot.transaction();
        transaction.create(childPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        transaction.check(childPath, 0);
        transaction.setData(childPath, childPath.getBytes(), 0);
        this.commit(transaction, useAsync);
        Assertions.assertNotNull((Object)this.zk.exists(chRoot + childPath, false), (String)("zNode is not created under chroot:" + chRoot));
        Assertions.assertNotNull((Object)this.zk_chroot.exists(childPath, false), (String)("zNode is not created under chroot:" + chRoot));
        Assertions.assertNull((Object)this.zk.exists(childPath, false), (String)"zNode is created directly under '/', ignored configured chroot");
        Assertions.assertArrayEquals((byte[])childPath.getBytes(), (byte[])this.zk_chroot.getData(childPath, false, null), (String)"zNode data not matching");
        transaction = this.zk_chroot.transaction();
        transaction.delete(childPath, 1);
        this.commit(transaction, useAsync);
        Assertions.assertNull((Object)this.zk.exists(chRoot + "/myid", false), (String)("chroot:" + chRoot + " exists after delete"));
        Assertions.assertNull((Object)this.zk_chroot.exists("/myid", false), (String)("chroot:" + chRoot + " exists after delete"));
    }

    private String createNameSpace(boolean useAsync) throws InterruptedException, KeeperException {
        String chRoot = "/appsX";
        Op createChRoot = Op.create((String)chRoot, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        this.multi(this.zk, Arrays.asList(createChRoot), useAsync);
        return chRoot;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCreate(boolean useAsync) throws Exception {
        this.multi(this.zk, Arrays.asList(Op.create((String)"/multi0", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi2", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT)), useAsync);
        this.zk.getData("/multi0", false, null);
        this.zk.getData("/multi1", false, null);
        this.zk.getData("/multi2", false, null);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testEmpty(boolean useAsync) throws Exception {
        this.multi(this.zk, Arrays.asList(new Op[0]), useAsync);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCreateDelete(boolean useAsync) throws Exception {
        this.multi(this.zk, Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0)), useAsync);
        Assertions.assertNull((Object)this.zk.exists("/multi", null));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInvalidVersion(boolean useAsync) throws Exception {
        try {
            this.multi(this.zk, Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)1)), useAsync);
            Assertions.fail((String)"delete /multi should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNestedCreate(boolean useAsync) throws Exception {
        this.multi(this.zk, Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi/a", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)"/multi/a/1", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi/a/1", (int)0), Op.delete((String)"/multi/a", (int)0), Op.delete((String)"/multi", (int)0)), useAsync);
        Assertions.assertNull((Object)this.zk.exists("/multi/a/1", null));
        Assertions.assertNull((Object)this.zk.exists("/multi/a", null));
        Assertions.assertNull((Object)this.zk.exists("/multi", null));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSetData(boolean useAsync) throws Exception {
        int i;
        String[] names = new String[]{"/multi0", "/multi1", "/multi2"};
        ArrayList<Op> ops = new ArrayList<Op>();
        for (i = 0; i < names.length; ++i) {
            ops.add(Op.create((String)names[i], (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            ops.add(Op.setData((String)names[i], (byte[])names[i].getBytes(), (int)0));
        }
        this.multi(this.zk, ops, useAsync);
        for (i = 0; i < names.length; ++i) {
            Assertions.assertArrayEquals((byte[])names[i].getBytes(), (byte[])this.zk.getData(names[i], false, null));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUpdateConflict(boolean useAsync) throws Exception {
        Assertions.assertNull((Object)this.zk.exists("/multi", null));
        try {
            this.multi(this.zk, Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/multi", (byte[])"X".getBytes(), (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0)), useAsync);
            Assertions.fail((String)"Should have thrown a KeeperException for invalid version");
        }
        catch (KeeperException e) {
            LOG.error("STACKTRACE: ", (Throwable)e);
        }
        Assertions.assertNull((Object)this.zk.exists("/multi", null));
        this.multi(this.zk, Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.setData((String)"/multi", (byte[])"X".getBytes(), (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)1)), useAsync);
        Assertions.assertArrayEquals((byte[])this.zk.getData("/multi", false, null), (byte[])"Y".getBytes());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeleteUpdateConflict(boolean useAsync) throws Exception {
        try {
            this.multi(this.zk, Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0)), useAsync);
            Assertions.fail((String)"/multi should have been deleted so setData should have failed");
        }
        catch (KeeperException keeperException) {
            // empty catch block
        }
        Assertions.assertNull((Object)this.zk.exists("/multi", null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetResults(boolean useAsync) throws Exception {
        List<Op> ops = Arrays.asList(Op.create((String)"/multi", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/multi", (int)0), Op.setData((String)"/multi", (byte[])"Y".getBytes(), (int)0), Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        List<OpResult> results = null;
        if (useAsync) {
            final MultiResult res = new MultiResult();
            this.zk.multi(ops, new AsyncCallback.MultiCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult multiResult = res;
                    synchronized (multiResult) {
                        res.rc = rc;
                        res.results = opResults;
                        res.finished = true;
                        res.notifyAll();
                    }
                }
            }, null);
            MultiResult multiResult = res;
            synchronized (multiResult) {
                while (!res.finished) {
                    res.wait();
                }
            }
            Assertions.assertFalse((KeeperException.Code.OK.intValue() == res.rc ? 1 : 0) != 0, (String)"/multi should have been deleted so setData should have failed");
            Assertions.assertNull((Object)this.zk.exists("/multi", null));
            results = res.results;
        } else {
            try {
                this.zk.multi(ops);
                Assertions.fail((String)"/multi should have been deleted so setData should have failed");
            }
            catch (KeeperException e) {
                Assertions.assertNull((Object)this.zk.exists("/multi", null));
                results = e.getResults();
            }
        }
        Assertions.assertNotNull(results);
        for (OpResult r : results) {
            LOG.info("RESULT==> {}", (Object)r);
            if (!(r instanceof OpResult.ErrorResult)) continue;
            OpResult.ErrorResult er = (OpResult.ErrorResult)r;
            LOG.info("ERROR RESULT: {} ERR=>{}", (Object)er, (Object)KeeperException.Code.get((int)er.getErr()));
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOpResultEquals(boolean useAsync) {
        this.opEquals((OpResult)new OpResult.CreateResult("/foo"), (OpResult)new OpResult.CreateResult("/foo"), (OpResult)new OpResult.CreateResult("nope"));
        this.opEquals((OpResult)new OpResult.CreateResult("/foo"), (OpResult)new OpResult.CreateResult("/foo"), (OpResult)new OpResult.CreateResult("/foo", new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)));
        this.opEquals((OpResult)new OpResult.CreateResult("/foo", new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.CreateResult("/foo", new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.CreateResult("nope", new Stat(11L, 12L, 13L, 14L, 15, 16, 17, 18L, 19, 110, 111L)));
        this.opEquals((OpResult)new OpResult.CreateResult("/foo", new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.CreateResult("/foo", new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.CreateResult("/foo"));
        this.opEquals((OpResult)new OpResult.CheckResult(), (OpResult)new OpResult.CheckResult(), null);
        this.opEquals((OpResult)new OpResult.SetDataResult(new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.SetDataResult(new Stat(1L, 2L, 3L, 4L, 5, 6, 7, 8L, 9, 10, 11L)), (OpResult)new OpResult.SetDataResult(new Stat(11L, 12L, 13L, 14L, 15, 16, 17, 18L, 19, 110, 111L)));
        this.opEquals((OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(2));
        this.opEquals((OpResult)new OpResult.DeleteResult(), (OpResult)new OpResult.DeleteResult(), null);
        this.opEquals((OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(1), (OpResult)new OpResult.ErrorResult(2));
    }

    private void opEquals(OpResult expected, OpResult value, OpResult near) {
        Assertions.assertEquals((Object)value, (Object)value);
        Assertions.assertFalse((boolean)value.equals(new Object()));
        Assertions.assertFalse((boolean)value.equals(near));
        Assertions.assertFalse((boolean)value.equals(value instanceof OpResult.CreateResult ? new OpResult.ErrorResult(1) : new OpResult.CreateResult("nope2")));
        Assertions.assertTrue((boolean)value.equals(expected));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testWatchesTriggered(boolean useAsync) throws KeeperException, InterruptedException {
        HasTriggeredWatcher watcher = new HasTriggeredWatcher();
        this.zk.getChildren("/", (Watcher)watcher);
        this.multi(this.zk, Arrays.asList(Op.create((String)"/t", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/t", (int)-1)), useAsync);
        Assertions.assertTrue((boolean)watcher.triggered.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testNoWatchesTriggeredForFailedMultiRequest(boolean useAsync) throws InterruptedException, KeeperException {
        HasTriggeredWatcher watcher = new HasTriggeredWatcher();
        this.zk.getChildren("/", (Watcher)watcher);
        try {
            this.multi(this.zk, Arrays.asList(Op.create((String)"/t", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.delete((String)"/nonexisting", (int)-1)), useAsync);
            Assertions.fail((String)"expected previous multi op to fail!");
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        SyncCallback cb = new SyncCallback();
        this.zk.sync("/", (AsyncCallback.VoidCallback)cb, null);
        cb.done.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((long)1L, (long)watcher.triggered.getCount());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTransactionBuilder(boolean useAsync) throws Exception {
        OpResult.CreateResult c;
        List<OpResult> results = this.commit(this.zk.transaction().create("/t1", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT).create("/t1/child", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT).create("/t2", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL), useAsync);
        Assertions.assertEquals((int)3, (int)results.size());
        for (OpResult r : results) {
            c = (OpResult.CreateResult)r;
            Assertions.assertTrue((boolean)c.getPath().startsWith("/t"));
            Assertions.assertNotNull((Object)c.toString());
        }
        Assertions.assertNotNull((Object)this.zk.exists("/t1", false));
        Assertions.assertNotNull((Object)this.zk.exists("/t1/child", false));
        Assertions.assertNotNull((Object)this.zk.exists("/t2", false));
        results = this.commit(this.zk.transaction().check("/t1", 0).check("/t1/child", 0).check("/t2", 0), useAsync);
        Assertions.assertEquals((int)3, (int)results.size());
        for (OpResult r : results) {
            c = (OpResult.CheckResult)r;
            Assertions.assertNotNull((Object)c.toString());
        }
        try {
            results = this.commit(this.zk.transaction().check("/t1", 0).check("/t1/child", 0).check("/t2", 1), useAsync);
            Assertions.fail();
        }
        catch (KeeperException.BadVersionException badVersionException) {
            // empty catch block
        }
        results = this.commit(this.zk.transaction().check("/t1", 0).setData("/t1", new byte[0], 0), useAsync);
        Assertions.assertEquals((int)2, (int)results.size());
        for (OpResult r : results) {
            Assertions.assertNotNull((Object)r.toString());
        }
        try {
            results = this.commit(this.zk.transaction().check("/t1", 1).setData("/t1", new byte[0], 2), useAsync);
            Assertions.fail();
        }
        catch (KeeperException.BadVersionException badVersionException) {
            // empty catch block
        }
        results = this.commit(this.zk.transaction().check("/t1", 1).check("/t1/child", 0).check("/t2", 0), useAsync);
        Assertions.assertEquals((int)3, (int)results.size());
        results = this.commit(this.zk.transaction().delete("/t2", -1).delete("/t1/child", -1), useAsync);
        Assertions.assertEquals((int)2, (int)results.size());
        for (OpResult r : results) {
            OpResult.DeleteResult d = (OpResult.DeleteResult)r;
            Assertions.assertNotNull((Object)d.toString());
        }
        Assertions.assertNotNull((Object)this.zk.exists("/t1", false));
        Assertions.assertNull((Object)this.zk.exists("/t1/child", false));
        Assertions.assertNull((Object)this.zk.exists("/t2", false));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiGetChildren(boolean useAsync) throws Exception {
        ArrayList<String> topLevelNodes = new ArrayList<String>();
        HashMap childrenNodes = new HashMap();
        for (int i = 0; i < 10; ++i) {
            String name = "/foo" + i;
            this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            topLevelNodes.add(name);
            childrenNodes.put(name, new ArrayList());
            for (int j = 0; j < 10; ++j) {
                String childname = name + "/bar" + i + j;
                String childname_s = "bar" + i + j;
                this.zk.create(childname, childname.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                ((List)childrenNodes.get(name)).add(childname_s);
            }
        }
        List<OpResult> multiChildrenList = this.multi(this.zk, topLevelNodes.stream().map(Op::getChildren).collect(Collectors.toList()), useAsync);
        for (int i = 0; i < topLevelNodes.size(); ++i) {
            String nodeName = (String)topLevelNodes.get(i);
            Assertions.assertTrue((boolean)(multiChildrenList.get(i) instanceof OpResult.GetChildrenResult));
            List childrenList = ((OpResult.GetChildrenResult)multiChildrenList.get(i)).getChildren();
            Assertions.assertEquals(new TreeSet(childrenList), new TreeSet((Collection)childrenNodes.get(nodeName)));
            List children = this.zk.getChildren(nodeName, false);
            Assertions.assertEquals((Object)childrenList, (Object)children);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiGetChildrenSameNode(boolean useAsync) throws Exception {
        ArrayList<String> childrenNodes = new ArrayList<String>();
        String topLevelNode = "/foo";
        this.zk.create(topLevelNode, topLevelNode.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int i = 0; i < 10; ++i) {
            String childname = topLevelNode + "/bar" + i;
            String childname_s = "bar" + i;
            this.zk.create(childname, childname.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            childrenNodes.add(childname_s);
        }
        List<OpResult> sameChildrenList = this.multi(this.zk, Arrays.asList(Op.getChildren((String)topLevelNode), Op.getChildren((String)topLevelNode)), useAsync);
        Assertions.assertEquals((int)sameChildrenList.size(), (int)2);
        Assertions.assertEquals((Object)sameChildrenList.get(0), (Object)sameChildrenList.get(1));
        Assertions.assertTrue((boolean)(sameChildrenList.get(0) instanceof OpResult.GetChildrenResult));
        OpResult.GetChildrenResult gcr = (OpResult.GetChildrenResult)sameChildrenList.get(0);
        Assertions.assertEquals(new TreeSet(gcr.getChildren()), new TreeSet(childrenNodes));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiGetChildrenAuthentication(boolean useAsync) throws KeeperException, InterruptedException {
        List<ACL> writeOnly = Collections.singletonList(new ACL(2, new Id("world", "anyone")));
        this.zk.create("/foo_auth", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/foo_auth/bar", null, (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/foo_no_auth", null, writeOnly, CreateMode.PERSISTENT);
        List<OpResult> multiChildrenList = this.multi(this.zk, Arrays.asList(Op.getChildren((String)"/foo_auth")), useAsync);
        Assertions.assertEquals((int)multiChildrenList.size(), (int)1);
        Assertions.assertTrue((boolean)(multiChildrenList.get(0) instanceof OpResult.GetChildrenResult));
        List childrenList = ((OpResult.GetChildrenResult)multiChildrenList.get(0)).getChildren();
        Assertions.assertEquals((int)childrenList.size(), (int)1);
        Assertions.assertEquals(childrenList.get(0), (Object)"bar");
        multiChildrenList = this.multi(this.zk, Arrays.asList(Op.getChildren((String)"/foo_no_auth")), useAsync);
        Assertions.assertEquals((int)multiChildrenList.size(), (int)1);
        Assertions.assertTrue((boolean)(multiChildrenList.get(0) instanceof OpResult.ErrorResult));
        Assertions.assertEquals((int)((OpResult.ErrorResult)multiChildrenList.get(0)).getErr(), (int)KeeperException.Code.NOAUTH.intValue(), (String)"Expected NoAuthException for getting the children of a write only node");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiGetChildrenMixedAuthenticationErrorFirst(boolean useAsync) throws KeeperException, InterruptedException {
        List<ACL> writeOnly = Collections.singletonList(new ACL(2, new Id("world", "anyone")));
        this.zk.create("/foo_auth", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/foo_auth/bar", null, (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/foo_no_auth", null, writeOnly, CreateMode.PERSISTENT);
        List<OpResult> multiChildrenList = this.multi(this.zk, Arrays.asList(Op.getChildren((String)"/foo_no_auth"), Op.getChildren((String)"/foo_auth")), useAsync);
        Assertions.assertEquals((int)multiChildrenList.size(), (int)2);
        Assertions.assertTrue((boolean)(multiChildrenList.get(0) instanceof OpResult.ErrorResult));
        Assertions.assertEquals((int)((OpResult.ErrorResult)multiChildrenList.get(0)).getErr(), (int)KeeperException.Code.NOAUTH.intValue(), (String)"Expected NoAuthException for getting the children of a write only node");
        Assertions.assertTrue((boolean)(multiChildrenList.get(1) instanceof OpResult.GetChildrenResult));
        List childrenList = ((OpResult.GetChildrenResult)multiChildrenList.get(1)).getChildren();
        Assertions.assertEquals((int)childrenList.size(), (int)1);
        Assertions.assertEquals(childrenList.get(0), (Object)"bar");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiGetChildrenMixedAuthenticationCorrectFirst(boolean useAsync) throws KeeperException, InterruptedException {
        List<ACL> writeOnly = Collections.singletonList(new ACL(2, new Id("world", "anyone")));
        this.zk.create("/foo_auth", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/foo_auth/bar", null, (List)ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/foo_no_auth", null, writeOnly, CreateMode.PERSISTENT);
        List<OpResult> multiChildrenList = this.multi(this.zk, Arrays.asList(Op.getChildren((String)"/foo_auth"), Op.getChildren((String)"/foo_no_auth")), useAsync);
        Assertions.assertSame((Object)multiChildrenList.size(), (Object)2);
        Assertions.assertTrue((boolean)(multiChildrenList.get(0) instanceof OpResult.GetChildrenResult));
        List childrenList = ((OpResult.GetChildrenResult)multiChildrenList.get(0)).getChildren();
        Assertions.assertEquals((int)childrenList.size(), (int)1);
        Assertions.assertEquals(childrenList.get(0), (Object)"bar");
        Assertions.assertTrue((boolean)(multiChildrenList.get(1) instanceof OpResult.ErrorResult));
        Assertions.assertEquals((int)((OpResult.ErrorResult)multiChildrenList.get(1)).getErr(), (int)KeeperException.Code.NOAUTH.intValue(), (String)"Expected NoAuthException for getting the children of a write only node");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiGetData(boolean useAsync) throws Exception {
        this.zk.create("/node1", "data1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/node2", "data2".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List<OpResult> multiData = this.multi(this.zk, Arrays.asList(Op.getData((String)"/node1"), Op.getData((String)"/node2")), useAsync);
        Assertions.assertEquals((int)multiData.size(), (int)2);
        Assertions.assertArrayEquals((byte[])((OpResult.GetDataResult)multiData.get(0)).getData(), (byte[])"data1".getBytes());
        Assertions.assertArrayEquals((byte[])((OpResult.GetDataResult)multiData.get(1)).getData(), (byte[])"data2".getBytes());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiRead(boolean useAsync) throws Exception {
        this.zk.create("/node1", "data1".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/node2", "data2".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        this.zk.create("/node1/node1", "data11".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/node1/node2", "data12".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List<OpResult> multiRead = this.multi(this.zk, Arrays.asList(Op.getChildren((String)"/node1"), Op.getData((String)"/node1"), Op.getChildren((String)"/node2"), Op.getData((String)"/node2")), useAsync);
        Assertions.assertEquals((int)multiRead.size(), (int)4);
        Assertions.assertTrue((boolean)(multiRead.get(0) instanceof OpResult.GetChildrenResult));
        List childrenList = ((OpResult.GetChildrenResult)multiRead.get(0)).getChildren();
        Assertions.assertEquals((int)childrenList.size(), (int)2);
        Assertions.assertEquals(new TreeSet(childrenList), new TreeSet<String>(Arrays.asList("node1", "node2")));
        Assertions.assertArrayEquals((byte[])((OpResult.GetDataResult)multiRead.get(1)).getData(), (byte[])"data1".getBytes());
        Stat stat = ((OpResult.GetDataResult)multiRead.get(1)).getStat();
        Assertions.assertEquals((long)stat.getMzxid(), (long)stat.getCzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)2, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)5, (int)stat.getDataLength());
        Assertions.assertEquals((int)2, (int)stat.getNumChildren());
        Assertions.assertTrue((boolean)(multiRead.get(2) instanceof OpResult.GetChildrenResult));
        childrenList = ((OpResult.GetChildrenResult)multiRead.get(2)).getChildren();
        Assertions.assertTrue((boolean)childrenList.isEmpty());
        Assertions.assertArrayEquals((byte[])((OpResult.GetDataResult)multiRead.get(3)).getData(), (byte[])"data2".getBytes());
        stat = ((OpResult.GetDataResult)multiRead.get(3)).getStat();
        Assertions.assertEquals((long)stat.getMzxid(), (long)stat.getCzxid());
        Assertions.assertEquals((long)stat.getMzxid(), (long)stat.getPzxid());
        Assertions.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assertions.assertEquals((int)0, (int)stat.getCversion());
        Assertions.assertEquals((int)0, (int)stat.getVersion());
        Assertions.assertEquals((int)0, (int)stat.getAversion());
        Assertions.assertEquals((long)this.zk.getSessionId(), (long)stat.getEphemeralOwner());
        Assertions.assertEquals((int)5, (int)stat.getDataLength());
        Assertions.assertEquals((int)0, (int)stat.getNumChildren());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMixedReadAndTransaction(boolean useAsync) throws Exception {
        this.zk.create("/node", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            List<OpResult> multiRead = this.multi(this.zk, Arrays.asList(Op.setData((String)"/node1", (byte[])"data1".getBytes(), (int)-1), Op.getData((String)"/node1")), useAsync);
            Assertions.fail((String)"Mixed kind of operations are not allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class SyncCallback
    implements AsyncCallback.VoidCallback {
        private final CountDownLatch done = new CountDownLatch(1);

        private SyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx) {
            this.done.countDown();
        }
    }

    private static class HasTriggeredWatcher
    implements Watcher {
        private final CountDownLatch triggered = new CountDownLatch(1);

        private HasTriggeredWatcher() {
        }

        public void process(WatchedEvent event) {
            this.triggered.countDown();
        }
    }

    static class MultiResult {
        int rc;
        List<OpResult> results;
        boolean finished = false;

        MultiResult() {
        }
    }
}

