/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.SecretUtilsTest;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.AuthFailX509AuthenticationProvider;
import org.apache.zookeeper.test.ClientBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientSSLTest
extends QuorumPeerTestBase {
    private ClientX509Util clientX509Util;

    @BeforeEach
    public void setup() {
        System.setProperty("zookeeper.client.portUnification", Boolean.TRUE.toString());
        this.clientX509Util = new ClientX509Util();
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty(this.clientX509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(this.clientX509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty(this.clientX509Util.getSslTruststoreLocationProperty(), testDataPath + "/ssl/testTrustStore.jks");
        System.setProperty(this.clientX509Util.getSslTruststorePasswdProperty(), "testpass");
    }

    @AfterEach
    public void teardown() {
        System.clearProperty("zookeeper.client.portUnification");
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty(this.clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(this.clientX509Util.getSslKeystorePasswdPathProperty());
        System.clearProperty(this.clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(this.clientX509Util.getSslTruststorePasswdProperty());
        System.clearProperty(this.clientX509Util.getSslTruststorePasswdPathProperty());
        this.clientX509Util.close();
    }

    @Test
    public void testClientServerUnifiedPort() throws Exception {
        this.testClientServerSSL(false);
    }

    @Test
    public void testClientServerUnifiedPortWithCnxnClassName() throws Exception {
        System.setProperty("zookeeper.clientCnxnSocket", "ClientCnxnSocketNIO");
        this.testClientServerSSL(false);
    }

    @Test
    public void testClientServerSSLWithCnxnClassName() throws Exception {
        System.setProperty("zookeeper.clientCnxnSocket", "ClientCnxnSocketNetty");
        this.testClientServerSSL(true);
    }

    @Test
    public void testClientServerSSL() throws Exception {
        this.testClientServerSSL(true);
    }

    @Test
    public void testClientServerSSL_withPasswordFromFile() throws Exception {
        Path secretFile = SecretUtilsTest.createSecretFile("testpass");
        System.clearProperty(this.clientX509Util.getSslKeystorePasswdProperty());
        System.setProperty(this.clientX509Util.getSslKeystorePasswdPathProperty(), secretFile.toString());
        System.clearProperty(this.clientX509Util.getSslTruststorePasswdProperty());
        System.setProperty(this.clientX509Util.getSslTruststorePasswdPathProperty(), secretFile.toString());
        this.testClientServerSSL(true);
    }

    public void testClientServerSSL(boolean useSecurePort) throws Exception {
        int i;
        int SERVER_COUNT = 3;
        int[] clientPorts = new int[3];
        Integer[] secureClientPorts = new Integer[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            secureClientPorts[i2] = PortAssignment.unique();
            String server = String.format("server.%d=127.0.0.1:%d:%d:participant;127.0.0.1:%d%n", i2, PortAssignment.unique(), PortAssignment.unique(), clientPorts[i2]);
            sb.append(server);
        }
        String quorumCfg = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = useSecurePort ? new QuorumPeerTestBase.MainThread(i, quorumCfg, secureClientPorts[i], true) : new QuorumPeerTestBase.MainThread(i, quorumCfg, true);
            mt[i].start();
        }
        ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[0], 10000L);
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], 5000L), (String)("waiting for server " + i + " being up"));
            int port = useSecurePort ? secureClientPorts[i] : clientPorts[i];
            ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + port, 5000);
            zk.create("/test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.delete("/test", -1);
            zk.close();
        }
        for (i = 0; i < mt.length; ++i) {
            mt[i].shutdown();
        }
    }

    @Test
    public void testSecureStandaloneServer() throws Exception {
        Integer secureClientPort = PortAssignment.unique();
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(-1, "", secureClientPort, false);
        mt.start();
        ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + secureClientPort, 5000);
        zk.create("/test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.delete("/test", -1);
        zk.close();
        mt.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSecureStandaloneServerAuthFail() throws IOException {
        try {
            System.setProperty("zookeeper.authProvider.authfail", AuthFailX509AuthenticationProvider.class.getName());
            System.setProperty(this.clientX509Util.getSslAuthProviderProperty(), "authfail");
            Integer secureClientPort = PortAssignment.unique();
            QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(-1, "", secureClientPort, false);
            mt.start();
            AssertionError ex = (AssertionError)((Object)Assert.assertThrows((String)"Client should not able to connect when authentication fails", AssertionError.class, () -> ClientBase.createZKClient("localhost:" + secureClientPort, 5000, 3000L)));
            MatcherAssert.assertThat((String)"Exception message does not match (different exception caught?)", (Object)((Throwable)((Object)ex)).getMessage(), (Matcher)CoreMatchers.startsWith((String)"ZooKeeper client can not connect to"));
        }
        finally {
            System.clearProperty("zookeeper.authProvider.authfail");
            System.clearProperty(this.clientX509Util.getSslAuthProviderProperty());
        }
    }
}

