/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class QuorumRequestPipelineTest
extends QuorumBase {
    protected final CountDownLatch callComplete = new CountDownLatch(1);
    protected boolean complete = false;
    protected static final String PARENT_PATH = "/foo";
    protected static final Set<String> CHILDREN = new HashSet<String>(Arrays.asList("1", "2", "3"));
    protected static final String AUTH_PROVIDER = "digest";
    protected static final byte[] AUTH = "hello".getBytes();
    protected static final byte[] DATA = "Hint Water".getBytes();
    protected TestableZooKeeper zkClient;

    public static Stream<Arguments> data() throws Exception {
        return Stream.of(Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.LEADING}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.FOLLOWING}), Arguments.of((Object[])new Object[]{QuorumPeer.ServerState.OBSERVING}));
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    public void setUp(QuorumPeer.ServerState serverState) throws Exception {
        ClientBase.CountdownWatcher clientWatch = new ClientBase.CountdownWatcher();
        super.setUp(true, true);
        this.zkClient = this.createClient(clientWatch, this.getPeersMatching(serverState));
        this.zkClient.addAuthInfo(AUTH_PROVIDER, AUTH);
        clientWatch.waitForConnected(CONNECTION_TIMEOUT);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.zkClient.close();
        super.tearDown();
    }

    private Stat create2EmptyNode(TestableZooKeeper zkClient, String path) throws Exception {
        Stat stat = new Stat();
        zkClient.create(path, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        return stat;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreate(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Assertions.assertArrayEquals((byte[])DATA, (byte[])this.zkClient.getData(PARENT_PATH, false, null), (String)String.format("%s Node created (create) with expected value", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreate2(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.zkClient.create(PARENT_PATH, DATA, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, null);
        Assertions.assertArrayEquals((byte[])DATA, (byte[])this.zkClient.getData(PARENT_PATH, false, null), (String)String.format("%s Node created (create2) with expected value", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testDelete(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        this.zkClient.delete(PARENT_PATH, -1);
        Assertions.assertNull((Object)this.zkClient.exists(PARENT_PATH, false), (String)String.format("%s Node no longer exists", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testExists(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        Stat stat = this.create2EmptyNode(this.zkClient, PARENT_PATH);
        Assertions.assertEquals((Object)stat, (Object)this.zkClient.exists(PARENT_PATH, false), (String)String.format("%s Exists returns correct node stat", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetAndGetData(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        this.zkClient.setData(PARENT_PATH, DATA, -1);
        Assertions.assertArrayEquals((byte[])DATA, (byte[])this.zkClient.getData(PARENT_PATH, false, null), (String)String.format("%s Node updated with expected value", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetAndGetACL(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        Assertions.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)this.zkClient.getACL(PARENT_PATH, new Stat()), (String)String.format("%s Node has open ACL", serverState));
        this.zkClient.setACL(PARENT_PATH, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
        Assertions.assertEquals((Object)ZooDefs.Ids.READ_ACL_UNSAFE, (Object)this.zkClient.getACL(PARENT_PATH, new Stat()), (String)String.format("%s Node has world read-only ACL", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetAndGetChildren(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        for (String child : CHILDREN) {
            this.create2EmptyNode(this.zkClient, "/foo/" + child);
        }
        Assertions.assertEquals(CHILDREN, new HashSet(this.zkClient.getChildren(PARENT_PATH, false)), (String)String.format("%s Parent has expected children", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSetAndGetChildren2(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        for (String child : CHILDREN) {
            this.create2EmptyNode(this.zkClient, "/foo/" + child);
        }
        Assertions.assertEquals(CHILDREN, new HashSet(this.zkClient.getChildren(PARENT_PATH, false, null)), (String)String.format("%s Parent has expected children", serverState));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSync(QuorumPeer.ServerState serverState) throws Exception {
        this.setUp(serverState);
        this.complete = false;
        this.create2EmptyNode(this.zkClient, PARENT_PATH);
        AsyncCallback.VoidCallback onSync = new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                QuorumRequestPipelineTest.this.complete = true;
                QuorumRequestPipelineTest.this.callComplete.countDown();
            }
        };
        this.zkClient.sync(PARENT_PATH, onSync, null);
        this.callComplete.await(30L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.complete, (String)String.format("%s Sync completed", serverState));
    }
}

