/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DigestAuthDisabledTest
extends ClientBase {
    private final CountDownLatch authFailed = new CountDownLatch(1);

    @BeforeAll
    public static void setUpEnvironment() {
        System.setProperty("zookeeper.DigestAuthenticationProvider.enabled", "false");
    }

    @AfterAll
    public static void cleanUpEnvironment() {
        System.clearProperty("zookeeper.DigestAuthenticationProvider.enabled");
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    @Test
    public void testDigestAuthDisabledTriggersAuthFailed() throws Exception {
        try (TestableZooKeeper zk = this.createClient();){
            zk.addAuthInfo("digest", "roger:muscadet".getBytes());
            zk.getData("/path1", false, null);
            Assertions.fail((String)"Should get auth state error");
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                DigestAuthDisabledTest.this.authFailed.countDown();
            } else {
                super.process(event);
            }
        }
    }
}

