/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.EnumSet;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateModeTest
extends ZKTestCase {
    @Test
    public void testBasicCreateMode() {
        CreateMode cm = CreateMode.PERSISTENT;
        Assertions.assertEquals((int)cm.toFlag(), (int)0);
        Assertions.assertFalse((boolean)cm.isEphemeral());
        Assertions.assertFalse((boolean)cm.isSequential());
        Assertions.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.EPHEMERAL;
        Assertions.assertEquals((int)cm.toFlag(), (int)1);
        Assertions.assertTrue((boolean)cm.isEphemeral());
        Assertions.assertFalse((boolean)cm.isSequential());
        Assertions.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.PERSISTENT_SEQUENTIAL;
        Assertions.assertEquals((int)cm.toFlag(), (int)2);
        Assertions.assertFalse((boolean)cm.isEphemeral());
        Assertions.assertTrue((boolean)cm.isSequential());
        Assertions.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.EPHEMERAL_SEQUENTIAL;
        Assertions.assertEquals((int)cm.toFlag(), (int)3);
        Assertions.assertTrue((boolean)cm.isEphemeral());
        Assertions.assertTrue((boolean)cm.isSequential());
        Assertions.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.CONTAINER;
        Assertions.assertEquals((int)cm.toFlag(), (int)4);
        Assertions.assertFalse((boolean)cm.isEphemeral());
        Assertions.assertFalse((boolean)cm.isSequential());
        Assertions.assertTrue((boolean)cm.isContainer());
    }

    @Test
    public void testFlagConversion() throws KeeperException {
        EnumSet<CreateMode> allModes = EnumSet.allOf(CreateMode.class);
        for (CreateMode cm : allModes) {
            Assertions.assertEquals((Object)cm, (Object)CreateMode.fromFlag((int)cm.toFlag()));
        }
    }

    @Test
    public void testInvalidFlagConversion() throws KeeperException {
        try {
            CreateMode.fromFlag((int)99);
            Assertions.fail((String)"Shouldn't be able to convert 99 to a CreateMode.");
        }
        catch (KeeperException ke) {
            Assertions.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
        try {
            CreateMode.fromFlag((int)-1);
            Assertions.fail((String)"Shouldn't be able to convert -1 to a CreateMode.");
        }
        catch (KeeperException ke) {
            Assertions.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
    }
}

