/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.net.InetSocketAddress;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.NetUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NetUtilsTest
extends ZKTestCase {
    private Integer port = 1234;
    private String v4addr = "127.0.0.1";
    private String v6addr = "[0:0:0:0:0:0:0:1]";
    private String v6addr2 = "[2600:0:0:0:0:0:0:0]";
    private String v4local = this.v4addr + ":" + this.port.toString();
    private String v6local = this.v6addr + ":" + this.port.toString();
    private String v6ext = this.v6addr2 + ":" + this.port.toString();

    @Test
    public void testFormatInetAddrGoodIpv4() {
        InetSocketAddress isa = new InetSocketAddress(this.v4addr, (int)this.port);
        Assertions.assertEquals((Object)"127.0.0.1:1234", (Object)NetUtils.formatInetAddr((InetSocketAddress)isa));
    }

    @Test
    public void testFormatInetAddrGoodIpv6Local() {
        InetSocketAddress isa = new InetSocketAddress("::1", (int)this.port);
        Assertions.assertEquals((Object)this.v6local, (Object)NetUtils.formatInetAddr((InetSocketAddress)isa));
    }

    @Test
    public void testFormatInetAddrGoodIpv6Ext() {
        InetSocketAddress isa = new InetSocketAddress("2600::", (int)this.port);
        Assertions.assertEquals((Object)this.v6ext, (Object)NetUtils.formatInetAddr((InetSocketAddress)isa));
    }

    @Test
    public void testFormatInetAddrGoodHostname() {
        InetSocketAddress isa = new InetSocketAddress("localhost", 1234);
        MatcherAssert.assertThat((Object)NetUtils.formatInetAddr((InetSocketAddress)isa), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)this.v4local), CoreMatchers.equalTo((Object)this.v6local)}));
    }

    @Test
    public void testFormatAddrUnresolved() {
        InetSocketAddress isa = InetSocketAddress.createUnresolved("doesnt.exist.com", 1234);
        Assertions.assertEquals((Object)"doesnt.exist.com:1234", (Object)NetUtils.formatInetAddr((InetSocketAddress)isa));
    }

    @Test
    public void tetGetIPV6HostAndPort_WhenHostDoesNotEndWithBracket() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NetUtils.getIPV6HostAndPort((String)"[2001:0db8:85a3:0000:0000:8a2e:0370:7334:443"));
    }

    @Test
    public void tetGetIPV6HostAndPort_WhenNoPortAfterColon() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NetUtils.getIPV6HostAndPort((String)"[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:"));
    }

    @Test
    public void tetGetIPV6HostAndPort_WhenPortIsNotSeparatedProperly() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NetUtils.getIPV6HostAndPort((String)"[2001:0db8:85a3:0000:0000:8a2e:0370:7334]2181"));
    }

    @Test
    public void tetGetIPV6HostAndPort_WhenHostIsEmpty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NetUtils.getIPV6HostAndPort((String)"[]:2181"));
    }

    @Test
    public void tetGetIPV6HostAndPort_EmptyStringArrayIfDoesNotStartWithBracket() {
        String[] ipv6HostAndPort = NetUtils.getIPV6HostAndPort((String)"2001:0db8:85a3:0000:0000:8a2e:0370:7334]");
        Assertions.assertEquals((int)0, (int)ipv6HostAndPort.length);
    }

    @Test
    public void tetGetIPV6HostAndPort_ReturnHostPort() {
        String[] ipv6HostAndPort = NetUtils.getIPV6HostAndPort((String)"[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:2181");
        Assertions.assertEquals((int)2, (int)ipv6HostAndPort.length);
        Assertions.assertEquals((Object)"2001:0db8:85a3:0000:0000:8a2e:0370:7334", (Object)ipv6HostAndPort[0]);
        Assertions.assertEquals((Object)"2181", (Object)ipv6HostAndPort[1]);
    }

    @Test
    public void tetGetIPV6HostAndPort_ReturnHostPortPort() {
        String[] ipv6HostAndPort = NetUtils.getIPV6HostAndPort((String)"[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:2181:3181");
        Assertions.assertEquals((int)2, (int)ipv6HostAndPort.length);
        Assertions.assertEquals((Object)"2001:0db8:85a3:0000:0000:8a2e:0370:7334", (Object)ipv6HostAndPort[0]);
        Assertions.assertEquals((Object)"2181:3181", (Object)ipv6HostAndPort[1]);
    }
}

