/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.server.util.RequestPathMetricsCollector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class RequestPathMetricsCollectorTest {
    @BeforeEach
    public void setUp() {
        System.setProperty("zookeeper.pathStats.enabled", "true");
        System.setProperty("zookeeper.pathStats.slotCapacity", "60");
        System.setProperty("zookeeper.pathStats.slotDuration", "1");
        System.setProperty("zookeeper.pathStats.maxDepth", "6");
        System.setProperty("zookeeper.pathStats.sampleRate", "1.0");
    }

    @AfterEach
    public void tearDown() {
        System.clearProperty("zookeeper.pathStats.enabled");
        System.clearProperty("zookeeper.pathStats.slotCapacity");
        System.clearProperty("zookeeper.pathStats.slotDuration");
        System.clearProperty("zookeeper.pathStats.maxDepth");
        System.clearProperty("zookeeper.pathStats.sampleRate");
    }

    @Test
    public void testTrimPath() {
        String trimedPath = RequestPathMetricsCollector.trimPathDepth((String)"/p1/p2/p3", (int)1);
        Assertions.assertTrue((boolean)trimedPath.equalsIgnoreCase("/p1"));
        trimedPath = RequestPathMetricsCollector.trimPathDepth((String)"/p1/p2/p3", (int)2);
        Assertions.assertTrue((boolean)trimedPath.equalsIgnoreCase("/p1/p2"));
        trimedPath = RequestPathMetricsCollector.trimPathDepth((String)"/p1/p2/p3", (int)3);
        Assertions.assertTrue((boolean)trimedPath.equalsIgnoreCase("/p1/p2/p3"));
        trimedPath = RequestPathMetricsCollector.trimPathDepth((String)"/p1/p2/p3", (int)4);
        Assertions.assertTrue((boolean)trimedPath.equalsIgnoreCase("/p1/p2/p3"));
        trimedPath = RequestPathMetricsCollector.trimPathDepth((String)"//p1 next/p2.index/p3:next", (int)3);
        Assertions.assertTrue((boolean)trimedPath.equalsIgnoreCase("/p1 next/p2.index/p3:next"));
        trimedPath = RequestPathMetricsCollector.trimPathDepth((String)"//p1 next/p2.index/p3:next", (int)2);
        Assertions.assertTrue((boolean)trimedPath.equalsIgnoreCase("/p1 next/p2.index"));
        trimedPath = RequestPathMetricsCollector.trimPathDepth((String)"//p1 next/p2.index/p3:next", (int)6);
        Assertions.assertTrue((boolean)trimedPath.equalsIgnoreCase("/p1 next/p2.index/p3:next"));
    }

    @Test
    public void testQueueMapReduce() throws InterruptedException {
        int i;
        RequestPathMetricsCollector requestPathMetricsCollector;
        RequestPathMetricsCollector requestPathMetricsCollector2 = requestPathMetricsCollector = new RequestPathMetricsCollector();
        requestPathMetricsCollector2.getClass();
        RequestPathMetricsCollector.PathStatsQueue pathStatsQueue = new RequestPathMetricsCollector.PathStatsQueue(requestPathMetricsCollector2, 15);
        Thread path7 = new Thread(() -> {
            for (int i = 0; i < 1000000; ++i) {
                pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5/path6/path7_" + i);
            }
        });
        path7.start();
        Thread path6 = new Thread(() -> {
            pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5/path6");
            for (int i = 1; i < 100000; ++i) {
                pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5/path6_" + i);
            }
        });
        path6.start();
        for (i = 0; i < 1; ++i) {
            pathStatsQueue.registerRequest("/path1");
        }
        for (i = 0; i < 10; ++i) {
            pathStatsQueue.registerRequest("/path1/path2_" + i);
        }
        for (i = 0; i < 100; ++i) {
            pathStatsQueue.registerRequest("/path1/path2/path3_" + i);
        }
        for (i = 0; i < 1000; ++i) {
            pathStatsQueue.registerRequest("/path1/path2/path3/path4_" + i);
        }
        for (i = 0; i < 10000; ++i) {
            pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5_" + i);
        }
        path6.join();
        path7.join();
        Map newSlot = pathStatsQueue.mapReducePaths(1, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((newSlot.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1")).compareTo(1111111) == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.mapReducePaths(2, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((newSlot.size() == 12 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1")).compareTo(1) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1/path2")).compareTo(1111100) == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.mapReducePaths(3, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((newSlot.size() == 112 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1")).compareTo(1) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1/path2/path3")).compareTo(1111000) == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.mapReducePaths(4, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((newSlot.size() == 1112 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1/path2/path3/path4")).compareTo(1110000) == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.mapReducePaths(5, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((newSlot.size() == 11112 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1/path2/path3/path4/path5")).compareTo(1100000) == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.mapReducePaths(6, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((newSlot.size() == 111111 ? 1 : 0) != 0);
        Assertions.assertTrue((((Integer)newSlot.get("/path1/path2/path3/path4/path5/path6")).compareTo(1000001) == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.mapReducePaths(7, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((newSlot.size() == 1111111 ? 1 : 0) != 0);
    }

    @Test
    public void testCollectEmptyStats() throws InterruptedException {
        RequestPathMetricsCollector requestPathMetricsCollector;
        RequestPathMetricsCollector requestPathMetricsCollector2 = requestPathMetricsCollector = new RequestPathMetricsCollector();
        requestPathMetricsCollector2.getClass();
        RequestPathMetricsCollector.PathStatsQueue pathStatsQueue = new RequestPathMetricsCollector.PathStatsQueue(requestPathMetricsCollector2, 8);
        Thread.sleep(5000L);
        Map newSlot = pathStatsQueue.mapReducePaths(3, (Collection)pathStatsQueue.getCurrentSlot());
        Assertions.assertTrue((boolean)newSlot.isEmpty());
        pathStatsQueue.start();
        Thread.sleep(15000L);
        newSlot = pathStatsQueue.collectStats(1);
        Assertions.assertTrue((newSlot.size() == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.collectStats(2);
        Assertions.assertTrue((newSlot.size() == 0 ? 1 : 0) != 0);
        newSlot = pathStatsQueue.collectStats(5);
        Assertions.assertTrue((newSlot.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    @Disabled
    public void testCollectStats() throws InterruptedException {
        int i;
        RequestPathMetricsCollector requestPathMetricsCollector;
        RequestPathMetricsCollector requestPathMetricsCollector2 = requestPathMetricsCollector = new RequestPathMetricsCollector(true);
        requestPathMetricsCollector2.getClass();
        RequestPathMetricsCollector.PathStatsQueue pathStatsQueue = new RequestPathMetricsCollector.PathStatsQueue(requestPathMetricsCollector2, 8);
        pathStatsQueue.start();
        Thread path7 = new Thread(() -> {
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (int j = 0; j < 100000; ++j) {
                    pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5/path6/path7_" + i + "_" + j);
                }
            }
        });
        path7.start();
        Thread path6 = new Thread(() -> {
            pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5/path6");
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (int j = 0; j < 10000; ++j) {
                    pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5/path6_" + i + "_" + j);
                }
            }
        });
        path6.start();
        for (i = 0; i < 1; ++i) {
            pathStatsQueue.registerRequest("/path1");
        }
        for (i = 0; i < 10; ++i) {
            pathStatsQueue.registerRequest("/path1/path2_" + i);
        }
        for (i = 0; i < 100; ++i) {
            pathStatsQueue.registerRequest("/path1/path2/path3_" + i);
        }
        for (i = 0; i < 1000; ++i) {
            pathStatsQueue.registerRequest("/path1/path2/path3/path4_" + i);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i2 = 0; i2 < 10000; ++i2) {
            pathStatsQueue.registerRequest("/path1/path2/path3/path4/path5_" + i2);
        }
        path6.join();
        path7.join();
        Map newSlot = pathStatsQueue.collectStats(1);
        Assertions.assertEquals((int)newSlot.size(), (int)1);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1")), (int)1111112);
        newSlot = pathStatsQueue.collectStats(2);
        Assertions.assertEquals((int)newSlot.size(), (int)12);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1")), (int)1);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2")), (int)1111101);
        newSlot = pathStatsQueue.collectStats(3);
        Assertions.assertEquals((int)newSlot.size(), (int)112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1")), (int)1);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3")), (int)1111001);
        newSlot = pathStatsQueue.collectStats(4);
        Assertions.assertEquals((int)newSlot.size(), (int)1112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4")), (int)1110001);
        newSlot = pathStatsQueue.collectStats(5);
        Assertions.assertEquals((int)newSlot.size(), (int)11112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4/path5")), (int)1100001);
        newSlot = pathStatsQueue.collectStats(6);
        Assertions.assertEquals((int)newSlot.size(), (int)111112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4/path5/path6")), (int)1000001);
    }

    @Test
    public void testAggregate() throws InterruptedException {
        int i;
        RequestPathMetricsCollector requestPathMetricsCollector = new RequestPathMetricsCollector(true);
        Thread path7 = new Thread(() -> {
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (int j = 0; j < 100000; ++j) {
                    requestPathMetricsCollector.registerRequest(4, "/path1/path2/path3/path4/path5/path6/path7_" + i + "_" + j);
                }
            }
        });
        path7.start();
        Thread path6 = new Thread(() -> {
            requestPathMetricsCollector.registerRequest(12, "/path1/path2/path3/path4/path5/path6");
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (int j = 0; j < 10000; ++j) {
                    requestPathMetricsCollector.registerRequest(8, "/path1/path2/path3/path4/path5/path6_" + i + "_" + j);
                }
            }
        });
        path6.start();
        for (i = 0; i < 1; ++i) {
            requestPathMetricsCollector.registerRequest(15, "/path1");
        }
        for (i = 0; i < 10; ++i) {
            requestPathMetricsCollector.registerRequest(1, "/path1/path2_" + i);
        }
        for (i = 0; i < 100; ++i) {
            requestPathMetricsCollector.registerRequest(2, "/path1/path2/path3_" + i);
        }
        for (i = 0; i < 1000; ++i) {
            requestPathMetricsCollector.registerRequest(5, "/path1/path2/path3/path4_" + i);
        }
        for (i = 0; i < 10000; ++i) {
            requestPathMetricsCollector.registerRequest(3, "/path1/path2/path3/path4/path5_" + i);
        }
        path6.join();
        path7.join();
        Map newSlot = requestPathMetricsCollector.aggregatePaths(2, queue -> true);
        Assertions.assertEquals((int)newSlot.size(), (int)12);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1")), (int)1);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2")), (int)1111101);
        newSlot = requestPathMetricsCollector.aggregatePaths(3, queue -> true);
        Assertions.assertEquals((int)newSlot.size(), (int)112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1")), (int)1);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3")), (int)1111001);
        newSlot = requestPathMetricsCollector.aggregatePaths(4, queue -> true);
        Assertions.assertEquals((int)newSlot.size(), (int)1112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4")), (int)1110001);
        newSlot = requestPathMetricsCollector.aggregatePaths(5, queue -> true);
        Assertions.assertEquals((int)newSlot.size(), (int)11112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4/path5")), (int)1100001);
        newSlot = requestPathMetricsCollector.aggregatePaths(6, queue -> true);
        Assertions.assertEquals((int)newSlot.size(), (int)111112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4/path5/path6")), (int)1000001);
        newSlot = requestPathMetricsCollector.aggregatePaths(7, queue -> true);
        Assertions.assertEquals((int)newSlot.size(), (int)111112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4/path5/path6")), (int)1000001);
        newSlot = requestPathMetricsCollector.aggregatePaths(4, queue -> !queue.isWriteOperation());
        Assertions.assertEquals((int)newSlot.size(), (int)1);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3/path4")), (int)1110001);
        newSlot = requestPathMetricsCollector.aggregatePaths(4, queue -> queue.isWriteOperation());
        Assertions.assertEquals((int)newSlot.size(), (int)1111);
        newSlot = requestPathMetricsCollector.aggregatePaths(3, queue -> queue.isWriteOperation());
        Assertions.assertEquals((int)newSlot.size(), (int)112);
        Assertions.assertEquals((int)((Integer)newSlot.get("/path1/path2/path3")), (int)1000);
    }

    @Test
    public void testTopPath() throws InterruptedException {
        int i;
        RequestPathMetricsCollector requestPathMetricsCollector = new RequestPathMetricsCollector(true);
        Thread path7 = new Thread(() -> {
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (int j = 0; j < 100000; ++j) {
                    requestPathMetricsCollector.registerRequest(4, "/path1/path2/path3/path4/path5/path6/path7_" + i + "_" + j);
                }
            }
        });
        path7.start();
        Thread path6 = new Thread(() -> {
            requestPathMetricsCollector.registerRequest(12, "/path1/path2/path3/path4/path5/path6");
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (int j = 0; j < 10000; ++j) {
                    requestPathMetricsCollector.registerRequest(8, "/path1/path2/path3/path4/path5/path6_" + i + "_" + j);
                }
            }
        });
        path6.start();
        for (i = 0; i < 1; ++i) {
            requestPathMetricsCollector.registerRequest(15, "/path1");
        }
        for (i = 0; i < 10; ++i) {
            requestPathMetricsCollector.registerRequest(1, "/path1/path2_" + i);
        }
        for (i = 0; i < 100; ++i) {
            requestPathMetricsCollector.registerRequest(2, "/path1/path2/path3_" + i);
        }
        for (i = 0; i < 1000; ++i) {
            requestPathMetricsCollector.registerRequest(5, "/path1/path2/path3/path4_" + i);
        }
        for (i = 0; i < 10000; ++i) {
            requestPathMetricsCollector.registerRequest(3, "/path1/path2/path3/path4/path5_" + i);
        }
        path6.join();
        path7.join();
        StringBuilder sb1 = new StringBuilder();
        Map newSlot = requestPathMetricsCollector.aggregatePaths(3, queue -> queue.isWriteOperation());
        requestPathMetricsCollector.logTopPaths(newSlot, entry -> sb1.append((String)entry.getKey() + " : " + entry.getValue() + "\n"));
        Assertions.assertTrue((boolean)sb1.toString().startsWith("/path1/path2/path3 : 1000"));
        StringBuilder sb2 = new StringBuilder();
        newSlot = requestPathMetricsCollector.aggregatePaths(3, queue -> !queue.isWriteOperation());
        requestPathMetricsCollector.logTopPaths(newSlot, entry -> sb2.append((String)entry.getKey() + " : " + entry.getValue() + "\n"));
        Assertions.assertTrue((boolean)sb2.toString().startsWith("/path1/path2/path3 : 1110001"));
        StringBuilder sb3 = new StringBuilder();
        newSlot = requestPathMetricsCollector.aggregatePaths(4, queue -> true);
        requestPathMetricsCollector.logTopPaths(newSlot, entry -> sb3.append((String)entry.getKey() + " : " + entry.getValue() + "\n"));
        Assertions.assertTrue((boolean)sb3.toString().startsWith("/path1/path2/path3/path4 : 1110001"));
    }

    @Test
    public void testMultiThreadPerf() throws InterruptedException {
        int i;
        RequestPathMetricsCollector requestPathMetricsCollector = new RequestPathMetricsCollector();
        Random rand = new Random(System.currentTimeMillis());
        Long startTime = System.currentTimeMillis();
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        for (i = 0; i < 100000; ++i) {
            executor.submit(() -> requestPathMetricsCollector.registerRequest(4, "/path1/path2/path" + rand.nextInt(10)));
        }
        for (i = 0; i < 5000; ++i) {
            executor.submit(() -> requestPathMetricsCollector.registerRequest(15, "/path1/path2/path" + rand.nextInt(10)));
        }
        for (i = 0; i < 5000; ++i) {
            executor.submit(() -> requestPathMetricsCollector.registerRequest(2, "/path1/path2/path" + rand.nextInt(10)));
        }
        for (i = 0; i < 40000; ++i) {
            executor.submit(() -> requestPathMetricsCollector.registerRequest(8, "/path1/path2/path" + rand.nextInt(10)));
        }
        executor.shutdown();
        executor.awaitTermination(10L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)executor.isTerminated());
        Long endTime = System.currentTimeMillis();
        Assertions.assertTrue((TimeUnit.MILLISECONDS.toSeconds(endTime - startTime) < 3L ? 1 : 0) != 0);
    }
}

