/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ServerConfigTest {
    private ServerConfig serverConfig;

    @BeforeEach
    public void setUp() {
        this.serverConfig = new ServerConfig();
    }

    @Test
    public void testFewArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String[] args = new String[]{"2181"};
            this.serverConfig.parse(args);
        });
    }

    @Test
    public void testValidArguments() {
        String[] args = new String[]{"2181", "/data/dir", "60000", "10000"};
        this.serverConfig.parse(args);
        Assertions.assertEquals((int)2181, (int)this.serverConfig.getClientPortAddress().getPort());
        Assertions.assertTrue((boolean)this.checkEquality("/data/dir", this.serverConfig.getDataDir()));
        Assertions.assertEquals((int)60000, (int)this.serverConfig.getTickTime());
        Assertions.assertEquals((int)10000, (int)this.serverConfig.getMaxClientCnxns());
    }

    @Test
    public void testTooManyArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String[] args = new String[]{"2181", "/data/dir", "60000", "10000", "9999"};
            this.serverConfig.parse(args);
        });
    }

    @Test
    public void testJvmPauseMonitorConfigured() {
        Long sleepTime = 444L;
        Long warnTH = 5555L;
        Long infoTH = 555L;
        QuorumPeerConfig qpConfig = (QuorumPeerConfig)Mockito.mock(QuorumPeerConfig.class);
        Mockito.when((Object)qpConfig.isJvmPauseMonitorToRun()).thenReturn((Object)true);
        Mockito.when((Object)qpConfig.getJvmPauseSleepTimeMs()).thenReturn((Object)sleepTime);
        Mockito.when((Object)qpConfig.getJvmPauseWarnThresholdMs()).thenReturn((Object)warnTH);
        Mockito.when((Object)qpConfig.getJvmPauseInfoThresholdMs()).thenReturn((Object)infoTH);
        this.serverConfig.readFrom(qpConfig);
        Assertions.assertEquals((Long)sleepTime, (Long)this.serverConfig.getJvmPauseSleepTimeMs());
        Assertions.assertEquals((Long)warnTH, (Long)this.serverConfig.getJvmPauseWarnThresholdMs());
        Assertions.assertEquals((Long)infoTH, (Long)this.serverConfig.getJvmPauseInfoThresholdMs());
        Assertions.assertTrue((boolean)this.serverConfig.isJvmPauseMonitorToRun());
    }

    boolean checkEquality(String a, String b) {
        Assertions.assertNotNull((Object)a);
        Assertions.assertNotNull((Object)b);
        return a.equals(b);
    }

    boolean checkEquality(String a, File b) {
        Assertions.assertNotNull((Object)a);
        Assertions.assertNotNull((Object)b);
        return new File(a).equals(b);
    }
}

