/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.jshell;

import java.util.Map;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.VMDisconnectedException;
import org.inferred.freebuilder.shaded.org.openjdk.jdi.VirtualMachine;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.JDIConnection;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.JShell;

class JDIEnv {
    private JDIConnection connection;
    private final JShell state;

    JDIEnv(JShell state) {
        this.state = state;
    }

    void init(String connectorName, Map<String, String> argumentName2Value, boolean openNow, int flags) {
        this.connection = new JDIConnection(this, connectorName, argumentName2Value, flags, this.state);
        if (!this.connection.isLaunch() || openNow) {
            this.connection.open();
        }
    }

    JDIConnection connection() {
        return this.connection;
    }

    VirtualMachine vm() {
        return this.connection.vm();
    }

    void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.disposeVM();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (Throwable e) {
                this.state.debug(1, null, "disposeVM threw: " + e);
            }
        }
        if (this.state != null) {
            try {
                this.state.closeDown();
            }
            catch (Throwable e) {
                this.state.debug(1, null, "state().closeDown() threw: " + e);
            }
        }
    }
}

