/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLETest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLETest.class);
    private final int MAX_LOOP_COUNTER = 300;
    private LEThread leThread;
    int count;
    Map<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<LEThread> threads;
    Map<Integer, HashSet<TestVote>> voteMap;
    Map<Long, LEThread> quora;
    File[] tmpdir;
    int[] port;
    int successCount;
    volatile Vote[] votes;
    volatile long leader = -1L;
    Random rand = new Random();
    Set<Long> joinedThreads;

    int countVotes(HashSet<TestVote> hs, long id) {
        int counter = 0;
        for (TestVote v : hs) {
            if (v.leader != id) continue;
            ++counter;
        }
        return counter;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.count = 7;
        this.peers = new HashMap<Long, QuorumPeer.QuorumServer>(this.count);
        this.threads = new ArrayList(this.count);
        this.voteMap = new HashMap<Integer, HashSet<TestVote>>();
        this.votes = new Vote[this.count];
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.successCount = 0;
        this.joinedThreads = new HashSet<Long>();
    }

    @AfterEach
    public void tearDown() throws Exception {
        for (int i = 0; i < this.threads.size(); ++i) {
            this.leThread = this.threads.get(i);
            QuorumBase.shutdown(this.leThread.peer);
        }
    }

    @Test
    public void testSingleElection() throws Exception {
        try {
            this.runElection(1);
        }
        catch (Exception e) {
            Assertions.fail((String)e.toString());
        }
    }

    @Test
    public void testDoubleElection() throws Exception {
        try {
            this.runElection(2);
        }
        catch (Exception e) {
            Assertions.fail((String)e.toString());
        }
    }

    @Test
    public void testTripleElection() throws Exception {
        try {
            this.runElection(3);
        }
        catch (Exception e) {
            Assertions.fail((String)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runElection(int rounds) throws Exception {
        FLETest peer;
        int i;
        ConcurrentHashMap<Long, HashSet<Integer>> quora = new ConcurrentHashMap<Long, HashSet<Integer>>();
        LOG.info("TestLE: {}, {}", (Object)this.getTestName(), (Object)this.count);
        for (i = 0; i < this.count; ++i) {
            this.port[i] = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", this.port[i])));
            this.tmpdir[i] = ClientBase.createTmpDir();
        }
        for (i = 0; i < this.count; ++i) {
            peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 1000, 2, 2, 2);
            peer.startLeaderElection();
            LEThread thread = new LEThread(this, (QuorumPeer)peer, i, rounds, quora);
            thread.start();
            this.threads.add(thread);
        }
        LOG.info("Started threads {}", (Object)this.getTestName());
        peer = this;
        synchronized (peer) {
            for (int waitCounter = 0; (this.successCount <= this.count / 2 || this.leader == -1L) && waitCounter < 300; ++waitCounter) {
                this.wait(200L);
            }
        }
        LOG.info("Success count: {}", (Object)this.successCount);
        for (int i2 = 0; i2 < this.threads.size(); ++i2) {
            if (!this.threads.get(i2).isAlive()) continue;
            LOG.info("Threads didn't join: {}", (Object)i2);
        }
        if (this.successCount <= this.count / 2) {
            Assertions.fail((String)"Fewer than a a majority has joined");
        }
        if (!this.joinedThreads.contains(this.leader)) {
            Assertions.fail((String)("Leader hasn't joined: " + this.leader));
        }
    }

    @Test
    public void testJoin() throws Exception {
        QuorumPeer peer;
        int sid;
        int waitTime = 10000;
        ArrayList<QuorumPeer> peerList = new ArrayList<QuorumPeer>();
        for (sid = 0; sid < 3; ++sid) {
            this.port[sid] = PortAssignment.unique();
            this.peers.put(Long.valueOf(sid), new QuorumPeer.QuorumServer((long)sid, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", this.port[sid])));
            this.tmpdir[sid] = ClientBase.createTmpDir();
        }
        for (sid = 0; sid < 2; ++sid) {
            peer = new QuorumPeer(this.peers, this.tmpdir[sid], this.tmpdir[sid], this.port[sid], 3, (long)sid, 2000, 2, 2, 2);
            LOG.info("Starting peer {}", (Object)peer.getId());
            peer.start();
            peerList.add(sid, peer);
        }
        peer = (QuorumPeer)peerList.get(0);
        VerifyState v1 = new VerifyState((QuorumPeer)peerList.get(0));
        v1.start();
        v1.join(waitTime);
        Assertions.assertFalse((!v1.isSuccess() ? 1 : 0) != 0, (String)("Unable to form cluster in " + waitTime + " ms"));
        peer = new QuorumPeer(this.peers, this.tmpdir[sid], this.tmpdir[sid], this.port[sid], 3, (long)sid, 2000, 2, 2, 2);
        LOG.info("Starting peer {}", (Object)peer.getId());
        peer.start();
        peerList.add(sid, peer);
        v1 = new VerifyState(peer);
        v1.start();
        v1.join(waitTime);
        if (v1.isAlive()) {
            Assertions.fail((String)("Peer " + peer.getId() + " failed to join the cluster within " + waitTime + " ms"));
        } else if (!v1.isSuccess()) {
            Assertions.fail((String)("Incorrect LEADING state for peer " + peer.getId()));
        }
        for (int id = 0; id < 3; ++id) {
            peer = (QuorumPeer)peerList.get(id);
            if (peer == null) continue;
            peer.shutdown();
        }
    }

    @Test
    public void testJoinInconsistentEnsemble() throws Exception {
        QuorumPeer peer;
        int sid;
        int waitTime = 10000;
        ArrayList<QuorumPeer> peerList = new ArrayList<QuorumPeer>();
        for (sid = 0; sid < 3; ++sid) {
            this.peers.put(Long.valueOf(sid), new QuorumPeer.QuorumServer((long)sid, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
            this.tmpdir[sid] = ClientBase.createTmpDir();
            this.port[sid] = PortAssignment.unique();
        }
        for (sid = 0; sid < 2; ++sid) {
            peer = new QuorumPeer(this.peers, this.tmpdir[sid], this.tmpdir[sid], this.port[sid], 3, (long)sid, 2000, 2, 2, 2);
            LOG.info("Starting peer {}", (Object)peer.getId());
            peer.start();
            peerList.add(sid, peer);
        }
        peer = (QuorumPeer)peerList.get(0);
        VerifyState v1 = new VerifyState((QuorumPeer)peerList.get(0));
        v1.start();
        v1.join(waitTime);
        Assertions.assertFalse((!v1.isSuccess() ? 1 : 0) != 0, (String)("Unable to form cluster in " + waitTime + " ms"));
        long leaderSid = peer.getCurrentVote().getId();
        long zxid = peer.getCurrentVote().getZxid();
        long electionEpoch = peer.getCurrentVote().getElectionEpoch();
        QuorumPeer.ServerState state = peer.getCurrentVote().getState();
        long peerEpoch = peer.getCurrentVote().getPeerEpoch();
        Vote newVote = new Vote(leaderSid, zxid + 100L, electionEpoch + 100L, peerEpoch, state);
        peer.setCurrentVote(newVote);
        peer = new QuorumPeer(this.peers, this.tmpdir[2], this.tmpdir[2], this.port[2], 3, 2L, 2000, 2, 2, 2);
        LOG.info("Starting peer {}", (Object)peer.getId());
        peer.start();
        peerList.add(sid, peer);
        v1 = new VerifyState(peer);
        v1.start();
        v1.join(waitTime);
        if (v1.isAlive()) {
            Assertions.fail((String)("Peer " + peer.getId() + " failed to join the cluster within " + waitTime + " ms"));
        }
        for (int id = 0; id < 3; ++id) {
            peer = (QuorumPeer)peerList.get(id);
            if (peer == null) continue;
            peer.shutdown();
        }
    }

    @Test
    public void testElectionTimeUnit() throws Exception {
        Assertions.assertEquals((Object)"MS", (Object)"MS");
    }

    static class VerifyState
    extends Thread {
        private volatile boolean success = false;
        private QuorumPeer peer;

        public VerifyState(QuorumPeer peer) {
            this.peer = peer;
        }

        @Override
        public void run() {
            this.setName("VerifyState-" + this.peer.getId());
            while (true) {
                if (this.peer.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                    LOG.info("I am following");
                    this.success = true;
                    break;
                }
                if (this.peer.getPeerState() == QuorumPeer.ServerState.LEADING) {
                    LOG.info("I am leading");
                    this.success = false;
                    break;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    LOG.warn("Sleep failed ", (Throwable)e);
                }
            }
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    class LEThread
    extends Thread {
        FLETest self;
        int i;
        QuorumPeer peer;
        int totalRounds;
        ConcurrentHashMap<Long, HashSet<Integer>> quora;

        LEThread(FLETest self, QuorumPeer peer, int i, int rounds, ConcurrentHashMap<Long, HashSet<Integer>> quora) {
            this.self = self;
            this.i = i;
            this.peer = peer;
            this.totalRounds = rounds;
            this.quora = quora;
            LOG.info("Constructor: {}", (Object)this.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vote v = null;
                while (true) {
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election again.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread {} got a null vote", (Object)this.i);
                        break;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: {}, {}", (Object)this.i, (Object)v.getId());
                    FLETest.this.votes[this.i] = v;
                    int lc = (int)((FastLeaderElection)this.peer.getElectionAlg()).getLogicalClock();
                    if (v.getId() == (long)this.i) {
                        LOG.info("I'm the leader: {}", (Object)this.i);
                        if (lc < this.totalRounds) {
                            LOG.info("Leader {} dying", (Object)this.i);
                            FastLeaderElection election = (FastLeaderElection)this.peer.getElectionAlg();
                            election.shutdown();
                            Assertions.assertEquals((long)-1L, (long)election.getVote().getId());
                            LOG.info("Leader {} dead", (Object)this.i);
                            break;
                        }
                    }
                    if (lc >= this.totalRounds) {
                        if (this.quora.get(v.getId()) == null) {
                            this.quora.put(v.getId(), new HashSet());
                        }
                        this.quora.get(v.getId()).add(this.i);
                        if (this.waitForQuorum(v.getId())) {
                            FLETest fLETest = this.self;
                            synchronized (fLETest) {
                                if (v.getId() == (long)this.i) {
                                    Assertions.assertTrue((this.peer.getPeerState() == QuorumPeer.ServerState.LEADING ? 1 : 0) != 0, (String)("Wrong state" + this.peer.getPeerState()));
                                    FLETest.this.leader = this.i;
                                } else {
                                    Assertions.assertTrue((this.peer.getPeerState() == QuorumPeer.ServerState.FOLLOWING ? 1 : 0) != 0, (String)("Wrong state" + this.peer.getPeerState()));
                                }
                                ++FLETest.this.successCount;
                                FLETest.this.joinedThreads.add(Long.valueOf(this.i));
                                this.self.notify();
                                break;
                            }
                        }
                        this.quora.get(v.getId()).remove(this.i);
                    }
                    Thread.sleep(100L);
                }
                LOG.debug("Thread {} votes {}", (Object)this.i, (Object)v);
            }
            catch (InterruptedException e) {
                Assertions.fail((String)e.toString());
            }
        }

        boolean waitForQuorum(long id) throws InterruptedException {
            int loopCounter;
            for (loopCounter = 0; this.quora.get(id).size() <= FLETest.this.count / 2 && loopCounter < 300; ++loopCounter) {
                Thread.sleep(100L);
            }
            return loopCounter < 300 || this.quora.get(id).size() > FLETest.this.count / 2;
        }
    }

    static class TestVote {
        long leader;

        TestVote(int id, long leader) {
            this.leader = leader;
        }
    }
}

