/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.List;
import java.util.UUID;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.cli.SetQuotaCommand;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ZooKeeperQuotaTest;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EnforceQuotaTest
extends ClientBase {
    private ZooKeeper zk;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.enforceQuota");
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testSetQuotaDisableWhenExceedBytesHardQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "12345".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        StatsTrack st = new StatsTrack();
        st.setByteHardLimit(5L);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        try {
            this.zk.setData(path, "123456".getBytes(), -1);
            ZooKeeperQuotaTest.validateNoQuotaExceededMetrics(namespace);
        }
        catch (KeeperException.QuotaExceededException e) {
            Assert.fail((String)"should not throw Byte Quota Exceeded Exception when enforce quota disables");
        }
    }

    @Test
    public void testSetQuotaDisableWhenExceedCountHardQuota() throws Exception {
        String namespace = UUID.randomUUID().toString();
        String path = "/" + namespace;
        this.zk.create(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int count = 2;
        StatsTrack st = new StatsTrack();
        st.setCountHardLimit((long)count);
        SetQuotaCommand.createQuota((ZooKeeper)this.zk, (String)path, (StatsTrack)st);
        this.zk.create(path + "/c2", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            this.zk.create(path + "/c2/c3", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ZooKeeperQuotaTest.validateNoQuotaExceededMetrics(namespace);
        }
        catch (KeeperException.QuotaExceededException e) {
            Assert.fail((String)"should not throw Count Quota Exceeded Exception when enforce quota disables");
        }
    }
}

