/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.Assert;
import org.junit.Test;

public class StandaloneDisabledTest
extends QuorumPeerTestBase {
    private final int NUM_SERVERS = 5;
    private QuorumPeerTestBase.MainThread[] peers;
    private ZooKeeper[] zkHandles;
    private ZooKeeperAdmin[] zkAdminHandles;
    private int[] clientPorts;
    private final int leaderId = 0;
    private final int follower1 = 1;
    private final int follower2 = 2;
    private final int observer1 = 3;
    private final int observer2 = 4;
    private ArrayList<String> serverStrings;
    private ArrayList<String> reconfigServers;

    @Test(timeout=600000L)
    public void startSingleServerTest() throws Exception {
        this.setUpData();
        this.startServer(0, this.serverStrings.get(0) + "\n");
        ReconfigTest.testServerHasConfig(this.zkHandles[0], null, null);
        LOG.info("Initial Configuration:\n{}", (Object)new String(this.zkHandles[0].getConfig((Watcher)this, new Stat())));
        this.startFollowers();
        this.testReconfig(0, true, this.reconfigServers);
        LOG.info("Configuration after adding 2 followers:\n{}", (Object)new String(this.zkHandles[0].getConfig((Watcher)this, new Stat())));
        this.shutDownServer(0);
        ReconfigTest.testNormalOperation(this.zkHandles[1], this.zkHandles[2]);
        this.reconfigServers.clear();
        this.reconfigServers.add(Integer.toString(2));
        try {
            ReconfigTest.reconfig(this.zkAdminHandles[1], null, this.reconfigServers, null, -1L);
            Assert.fail((String)"reconfig completed successfully even though there is no quorum up in new config!");
        }
        catch (KeeperException.NewConfigNoQuorum newConfigNoQuorum) {
            // empty catch block
        }
        this.reconfigServers.clear();
        this.reconfigServers.add(Integer.toString(0));
        this.reconfigServers.add(Integer.toString(1));
        this.testReconfig(2, false, this.reconfigServers);
        LOG.info("Configuration after removing leader and follower 1:\n{}", (Object)new String(this.zkHandles[2].getConfig((Watcher)this, new Stat())));
        this.shutDownServer(1);
        this.reconfigServers.clear();
        this.reconfigServers.add(Integer.toString(2));
        try {
            this.zkAdminHandles[2].reconfigure(null, this.reconfigServers, null, -1L, new Stat());
            Assert.fail((String)"reconfig completed successfully even though there is no quorum up in new config!");
        }
        catch (KeeperException.BadArgumentsException badArgumentsException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Should have been BadArgumentsException!");
        }
        ArrayList<String> observerStrings = new ArrayList<String>();
        this.startObservers(observerStrings);
        this.testReconfig(2, true, this.reconfigServers);
        this.testReconfig(2, true, observerStrings);
        LOG.info("Configuration after adding two observers:\n{}", (Object)new String(this.zkHandles[2].getConfig((Watcher)this, new Stat())));
        this.shutDownData();
    }

    private void setUpData() throws Exception {
        ClientBase.setupTestEnv();
        QuorumPeerConfig.setStandaloneEnabled((boolean)false);
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        this.peers = new QuorumPeerTestBase.MainThread[5];
        this.zkHandles = new ZooKeeper[5];
        this.zkAdminHandles = new ZooKeeperAdmin[5];
        this.clientPorts = new int[5];
        this.serverStrings = this.buildServerStrings();
        this.reconfigServers = new ArrayList();
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
    }

    private void shutDownData() throws Exception {
        int i;
        for (i = 0; i < 5; ++i) {
            this.zkHandles[i].close();
            this.zkAdminHandles[i].close();
        }
        for (i = 1; i < 5; ++i) {
            this.peers[i].shutdown();
        }
    }

    private ArrayList<String> buildServerStrings() {
        ArrayList<String> serverStrings = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            this.clientPorts[i] = PortAssignment.unique();
            String server = "server." + i + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + this.clientPorts[i];
            serverStrings.add(server);
        }
        return serverStrings;
    }

    private void startServer(int id, String config) throws Exception {
        this.peers[id] = new QuorumPeerTestBase.MainThread(id, this.clientPorts[id], config);
        this.peers[id].start();
        Assert.assertTrue((String)("Server " + id + " is not up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts[id], ClientBase.CONNECTION_TIMEOUT));
        Assert.assertTrue((String)"Error- Server started in Standalone Mode!", (boolean)this.peers[id].isQuorumPeerRunning());
        this.zkHandles[id] = ClientBase.createZKClient("127.0.0.1:" + this.clientPorts[id]);
        this.zkAdminHandles[id] = new ZooKeeperAdmin("127.0.0.1:" + this.clientPorts[id], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        this.zkAdminHandles[id].addAuthInfo("digest", "super:test".getBytes());
        String statCommandOut = FourLetterWordMain.send4LetterWord((String)"127.0.0.1", (int)this.clientPorts[id], (String)"stat");
        LOG.info("Started server id {} with config:\n{}\nStat output:\n{}", new Object[]{id, config, statCommandOut});
    }

    private void shutDownServer(int id) throws Exception {
        this.peers[id].shutdown();
        ClientBase.waitForServerDown("127.0.0.1:" + this.clientPorts[id], ClientBase.CONNECTION_TIMEOUT);
        TimeUnit.SECONDS.sleep(25L);
    }

    private void startFollowers() throws Exception {
        this.reconfigServers.clear();
        for (int i = 1; i <= 2; ++i) {
            String config = this.serverStrings.get(0) + "\n" + this.serverStrings.get(i) + "\n" + this.serverStrings.get(i % 2 + 1) + "\n";
            this.startServer(i, config);
            this.reconfigServers.add(this.serverStrings.get(i));
        }
    }

    private void startObservers(ArrayList<String> observerStrings) throws Exception {
        this.reconfigServers.clear();
        for (int i = 3; i <= 4; ++i) {
            String config = this.serverStrings.get(2) + "\n" + this.serverStrings.get(i) + "\n";
            this.startServer(i, config);
            this.reconfigServers.add(this.serverStrings.get(i));
            observerStrings.add(this.serverStrings.get(i).replace("participant", "observer"));
        }
    }

    private void testReconfig(int id, boolean adding, ArrayList<String> servers) throws Exception {
        if (adding) {
            ReconfigTest.reconfig(this.zkAdminHandles[id], servers, null, null, -1L);
            for (String server : servers) {
                int id2 = Integer.parseInt(server.substring(7, 8));
                ReconfigTest.testNormalOperation(this.zkHandles[id], this.zkHandles[id2]);
            }
            ReconfigTest.testServerHasConfig(this.zkHandles[id], servers, null);
        } else {
            ReconfigTest.reconfig(this.zkAdminHandles[id], null, servers, null, -1L);
            ReconfigTest.testServerHasConfig(this.zkHandles[id], null, servers);
        }
    }

    @Test
    public void startObserver() throws Exception {
        int clientPort = PortAssignment.unique();
        String config = "server.3=localhost:" + PortAssignment.unique() + ":" + clientPort + ":observer;localhost:" + PortAssignment.unique();
        QuorumPeerTestBase.MainThread observer = new QuorumPeerTestBase.MainThread(3, clientPort, config);
        observer.start();
        Assert.assertFalse((String)"Observer was able to start by itself!", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT));
    }
}

