/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.conf;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;

public class StorageConfiguration
extends ComponentConfiguration {
    private static final String COMPONENT_PREFIX = "storage.";
    private static final String RANGE_STORE_DIRS = "range.store.dirs";
    private static final String SERVE_READONLY_TABLES = "serve.readonly.tables";
    private static final String CONTROLLER_SCHEDULE_INTERVAL_MS = "cluster.controller.schedule.interval.ms";
    private static final String CHECKPOINT_CHECKSUM_ENABLE = "checkpoint.checksum.enable";
    private static final String CHECKPOINT_CHECKSUM_COMPATIBLE = "checkpoint.checksum.compatible";

    public StorageConfiguration(CompositeConfiguration conf) {
        super(conf, COMPONENT_PREFIX);
    }

    public StorageConfiguration setRangeStoreDirNames(String[] dirNames) {
        this.setProperty(RANGE_STORE_DIRS, dirNames);
        return this;
    }

    private String[] getRangeStoreDirNames() {
        String[] rangeStoreDirs = this.getStringArray(RANGE_STORE_DIRS);
        if (null == rangeStoreDirs || 0 == rangeStoreDirs.length) {
            return new String[]{"data/bookkeeper/ranges"};
        }
        return rangeStoreDirs;
    }

    public File[] getRangeStoreDirs() {
        String[] rangeStoreDirNames = this.getRangeStoreDirNames();
        File[] rangeStoreDirs = new File[rangeStoreDirNames.length];
        for (int i = 0; i < rangeStoreDirNames.length; ++i) {
            rangeStoreDirs[i] = new File(rangeStoreDirNames[i]);
        }
        return rangeStoreDirs;
    }

    public StorageConfiguration setServeReadOnlyTables(boolean serveReadOnlyTables) {
        this.setProperty(SERVE_READONLY_TABLES, serveReadOnlyTables);
        return this;
    }

    public boolean getServeReadOnlyTables() {
        return this.getBoolean(SERVE_READONLY_TABLES, false);
    }

    public long getClusterControllerScheduleIntervalMs() {
        return this.getLong(CONTROLLER_SCHEDULE_INTERVAL_MS, TimeUnit.SECONDS.toMillis(30L));
    }

    public StorageConfiguration setClusterControllerScheduleInterval(long time, TimeUnit timeUnit) {
        this.setProperty(CONTROLLER_SCHEDULE_INTERVAL_MS, timeUnit.toMillis(time));
        return this;
    }

    public boolean getCheckpointChecksumEnable() {
        return this.getBoolean(CHECKPOINT_CHECKSUM_ENABLE, true);
    }

    public boolean getCheckpointChecksumCompatible() {
        return this.getBoolean(CHECKPOINT_CHECKSUM_COMPATIBLE, true);
    }
}

