/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.grpc.ConnectivityState;
import io.grpc.rls.SubchannelStateManager;
import java.util.HashMap;
import javax.annotation.Nullable;

final class SubchannelStateManagerImpl
implements SubchannelStateManager {
    private final HashMap<String, ConnectivityState> stateMap = new HashMap();
    private final Multiset<ConnectivityState> stateMultiset = HashMultiset.create();

    SubchannelStateManagerImpl() {
    }

    @Override
    public void updateState(String name, ConnectivityState newState) {
        ConnectivityState existing;
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)newState, (Object)"newState");
        if (newState == ConnectivityState.SHUTDOWN) {
            existing = this.stateMap.remove(name);
        } else {
            existing = this.stateMap.put(name, newState);
            this.stateMultiset.add((Object)newState);
        }
        if (existing != null) {
            this.stateMultiset.remove((Object)existing);
        }
    }

    @Override
    @Nullable
    public ConnectivityState getState(String name) {
        return this.stateMap.get(Preconditions.checkNotNull((Object)name, (Object)"name"));
    }

    @Override
    public ConnectivityState getAggregatedState() {
        if (this.stateMultiset.contains((Object)ConnectivityState.READY)) {
            return ConnectivityState.READY;
        }
        if (this.stateMultiset.contains((Object)ConnectivityState.CONNECTING)) {
            return ConnectivityState.CONNECTING;
        }
        if (this.stateMultiset.contains((Object)ConnectivityState.IDLE)) {
            return ConnectivityState.IDLE;
        }
        if (this.stateMultiset.contains((Object)ConnectivityState.TRANSIENT_FAILURE)) {
            return ConnectivityState.TRANSIENT_FAILURE;
        }
        return ConnectivityState.IDLE;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stateMap", this.stateMap).toString();
    }
}

