/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.bookkeeper.statelib.api.exceptions.StateStoreException;
import org.apache.bookkeeper.statelib.impl.rocksdb.RocksUtils;
import org.apache.bookkeeper.stream.proto.kv.store.CheckpointMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksdbRestoreTask {
    private static final Logger log = LoggerFactory.getLogger(RocksdbRestoreTask.class);
    private final String dbName;
    private final File checkpointDir;
    private final CheckpointStore checkpointStore;
    private final String dbPrefix;

    public RocksdbRestoreTask(String dbName, File checkpointDir, CheckpointStore checkpointStore) {
        this.dbName = dbName;
        this.checkpointDir = checkpointDir;
        this.checkpointStore = checkpointStore;
        this.dbPrefix = String.format("%s", dbName);
    }

    public void restore(String checkpointId, CheckpointMetadata metadata) throws StateStoreException {
        File checkpointedDir = new File(this.checkpointDir, checkpointId);
        try {
            List<String> filesToCopy = this.getFilesToCopy(checkpointId, checkpointedDir, metadata);
            this.copyFilesFromRemote(checkpointId, checkpointedDir, filesToCopy);
        }
        catch (IOException ioe) {
            log.error("Failed to restore checkpoint {} to local directory {}", new Object[]{checkpointId, checkpointedDir, ioe});
            throw new StateStoreException("Failed to restore checkpoint " + checkpointId + " to local directory " + checkpointedDir, ioe);
        }
    }

    private List<String> getFilesToCopy(String checkpointId, File checkpointedDir, CheckpointMetadata metadata) throws IOException {
        if (!checkpointedDir.exists()) {
            Files.createDirectories(Paths.get(checkpointedDir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        ArrayList filesToCopy = Lists.newArrayListWithExpectedSize((int)metadata.getFilesCount());
        for (String fileName : metadata.getFilesList()) {
            long localFileLength;
            File localFile = new File(checkpointedDir, fileName);
            if (!localFile.exists()) {
                filesToCopy.add(fileName);
                continue;
            }
            String srcFile = RocksUtils.isSstFile(localFile) ? RocksUtils.getDestSstPath(this.dbPrefix, localFile) : RocksUtils.getDestPath(this.dbPrefix, checkpointId, localFile);
            long srcFileLength = this.checkpointStore.getFileLength(srcFile);
            if (srcFileLength == (localFileLength = localFile.length())) continue;
            filesToCopy.add(fileName);
        }
        return filesToCopy;
    }

    private void copyFilesFromRemote(String checkpointId, File checkpointedDir, List<String> remoteFiles) throws IOException {
        for (String file : remoteFiles) {
            this.copyFileFromRemote(checkpointId, checkpointedDir, file);
        }
    }

    private void copyFileFromRemote(String checkpointId, File checkpointedDir, String remoteFile) throws IOException {
        File localFile = new File(checkpointedDir, remoteFile);
        String remoteFilePath = RocksUtils.isSstFile(localFile) ? RocksUtils.getDestSstPath(this.dbPrefix, localFile) : RocksUtils.getDestPath(this.dbPrefix, checkpointId, localFile);
        byte[] data = new byte[131072];
        try (InputStream is = this.checkpointStore.openInputStream(remoteFilePath);){
            Files.copy(is, Paths.get(localFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

