/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.exceptions.DLIllegalStateException;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.zk.ZKOp;
import org.apache.distributedlog.zk.ZKTransaction;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestZKTransaction {
    @Test(timeout=60000L)
    public void testProcessNullResults() throws Exception {
        ZooKeeperClient zkc = (ZooKeeperClient)Mockito.mock(ZooKeeperClient.class);
        ZKTransaction transaction = new ZKTransaction(zkc);
        int numOps = 3;
        CountDownLatch commitLatch = new CountDownLatch(numOps);
        CountDownLatch abortLatch = new CountDownLatch(numOps);
        for (int i = 0; i < numOps; ++i) {
            transaction.addOp((Transaction.Op)new CountDownZKOp(commitLatch, abortLatch));
        }
        transaction.processResult(KeeperException.Code.CONNECTIONLOSS.intValue(), "test-path", null, null);
        abortLatch.await();
        Assert.assertEquals((long)0L, (long)abortLatch.getCount());
        Assert.assertEquals((long)numOps, (long)commitLatch.getCount());
    }

    @Test(timeout=60000L)
    public void testAbortTransaction() throws Exception {
        ZooKeeperClient zkc = (ZooKeeperClient)Mockito.mock(ZooKeeperClient.class);
        ZKTransaction transaction = new ZKTransaction(zkc);
        int numOps = 3;
        CountDownLatch commitLatch = new CountDownLatch(numOps);
        CountDownLatch abortLatch = new CountDownLatch(numOps);
        for (int i = 0; i < numOps; ++i) {
            transaction.addOp((Transaction.Op)new CountDownZKOp(commitLatch, abortLatch));
        }
        transaction.abort((Throwable)new DLIllegalStateException("Illegal State"));
        abortLatch.await();
        Assert.assertEquals((long)0L, (long)abortLatch.getCount());
        Assert.assertEquals((long)numOps, (long)commitLatch.getCount());
    }

    static class CountDownZKOp
    extends ZKOp {
        final CountDownLatch commitLatch;
        final CountDownLatch abortLatch;

        CountDownZKOp(CountDownLatch commitLatch, CountDownLatch abortLatch) {
            super((Op)Mockito.mock(Op.class));
            this.commitLatch = commitLatch;
            this.abortLatch = abortLatch;
        }

        protected void commitOpResult(OpResult opResult) {
            this.commitLatch.countDown();
        }

        protected void abortOpResult(Throwable t, @Nullable OpResult opResult) {
            this.abortLatch.countDown();
        }
    }
}

