/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.shims.zk;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;

class ZooKeeperServerShimImpl
implements ZooKeeperServerShim {
    ZooKeeperServer zks = null;
    NIOServerCnxnFactory serverFactory = null;

    ZooKeeperServerShimImpl() {
    }

    @Override
    public void initialize(File snapDir, File logDir, int zkPort, int maxCC) throws IOException {
        this.zks = new ZooKeeperServer(snapDir, logDir, 3000);
        this.serverFactory = new NIOServerCnxnFactory();
        this.serverFactory.configure(new InetSocketAddress(zkPort), maxCC);
    }

    @Override
    public void start() throws IOException {
        if (null == this.zks || null == this.serverFactory) {
            throw new IOException("Start zookeeper server before initialization.");
        }
        try {
            this.serverFactory.startup(this.zks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted when starting zookeeper server : ", e);
        }
    }

    @Override
    public void stop() {
        if (null != this.serverFactory) {
            this.serverFactory.shutdown();
        }
        if (null != this.zks) {
            this.zks.shutdown();
        }
    }
}

