/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BookieService.class);
    private final ServerConfiguration serverConf = new ServerConfiguration();
    private BookieServer bs;

    public BookieService(BookieConfiguration conf, StatsLogger statsLogger, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws Exception {
        super("bookie-server", (ComponentConfiguration)conf, statsLogger);
        this.serverConf.loadConf(conf.getUnderlyingConf());
        String hello = String.format("Hello, I'm your bookie, bookieId is %1$s, listening on port %2$s. Metadata service uri is %3$s. Journals are in %4$s. Ledgers are stored in %5$s.", this.serverConf.getBookieId() != null ? this.serverConf.getBookieId() : "<not-set>", this.serverConf.getBookiePort(), this.serverConf.getMetadataServiceUriUnchecked(), Arrays.asList(this.serverConf.getJournalDirNames()), Arrays.asList(this.serverConf.getLedgerDirNames()));
        log.info(hello);
        this.bs = new BookieServer(this.serverConf, statsLogger, bookieServiceInfoProvider);
    }

    protected void doStart() {
        try {
            this.bs.start();
            log.info("Started bookie server successfully.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start bookie server", e);
        }
    }

    protected void doStop() {
        if (null != this.bs) {
            this.bs.shutdown();
        }
    }

    protected void doClose() throws IOException {
    }

    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        try {
            BookieSocketAddress localAddress = this.bs.getLocalAddress();
            ArrayList<String> extensions = new ArrayList<String>();
            if (this.serverConf.getTLSProviderFactoryClass() != null) {
                extensions.add("tls");
            }
            ComponentInfoPublisher.EndpointInfo endpoint = new ComponentInfoPublisher.EndpointInfo("bookie", localAddress.getPort(), localAddress.getHostName(), "bookie-rpc", null, extensions);
            componentInfoPublisher.publishEndpoint(endpoint);
        }
        catch (UnknownHostException err) {
            log.error("Cannot compute local address", (Throwable)err);
        }
    }

    public ServerConfiguration serverConf() {
        return this.serverConf;
    }
}

