/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.codahale;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.codahale.CodahaleStatsLogger;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodahaleMetricsProvider
implements StatsProvider {
    static final Logger LOG = LoggerFactory.getLogger(CodahaleMetricsProvider.class);
    MetricRegistry metrics = null;
    List<ScheduledReporter> reporters = new ArrayList<ScheduledReporter>();
    JmxReporter jmx = null;

    synchronized void initIfNecessary() {
        if (this.metrics == null) {
            this.metrics = new MetricRegistry();
            this.metrics.registerAll((MetricSet)new MemoryUsageGaugeSet());
            this.metrics.registerAll((MetricSet)new GarbageCollectorMetricSet());
        }
    }

    public synchronized MetricRegistry getMetrics() {
        return this.metrics;
    }

    public void start(Configuration conf) {
        this.initIfNecessary();
        int metricsOutputFrequency = conf.getInt("codahaleStatsOutputFrequencySeconds", 60);
        String prefix = conf.getString("codahaleStatsPrefix", "");
        String graphiteHost = conf.getString("codahaleStatsGraphiteEndpoint");
        String csvDir = conf.getString("codahaleStatsCSVEndpoint");
        String slf4jCat = conf.getString("codahaleStatsSlf4jEndpoint");
        String jmxDomain = conf.getString("codahaleStatsJmxEndpoint");
        if (!Strings.isNullOrEmpty((String)graphiteHost)) {
            LOG.info("Configuring stats with graphite");
            HostAndPort addr = HostAndPort.fromString((String)graphiteHost);
            Graphite graphite = new Graphite(new InetSocketAddress(addr.getHost(), addr.getPort()));
            this.reporters.add((ScheduledReporter)GraphiteReporter.forRegistry((MetricRegistry)this.getMetrics()).prefixedWith(prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build((GraphiteSender)graphite));
        }
        if (!Strings.isNullOrEmpty((String)csvDir)) {
            File outdir = !Strings.isNullOrEmpty((String)prefix) ? new File(csvDir, prefix) : new File(csvDir);
            LOG.info("Configuring stats with csv output to directory [{}]", (Object)outdir.getAbsolutePath());
            this.reporters.add((ScheduledReporter)CsvReporter.forRegistry((MetricRegistry)this.getMetrics()).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(outdir));
        }
        if (!Strings.isNullOrEmpty((String)slf4jCat)) {
            LOG.info("Configuring stats with slf4j");
            this.reporters.add((ScheduledReporter)Slf4jReporter.forRegistry((MetricRegistry)this.getMetrics()).outputTo(LoggerFactory.getLogger((String)slf4jCat)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build());
        }
        if (!Strings.isNullOrEmpty((String)jmxDomain)) {
            LOG.info("Configuring stats with jmx");
            this.jmx = JmxReporter.forRegistry((MetricRegistry)this.getMetrics()).inDomain(jmxDomain).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            this.jmx.start();
        }
        for (ScheduledReporter r : this.reporters) {
            r.start((long)metricsOutputFrequency, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        for (ScheduledReporter r : this.reporters) {
            r.report();
            r.stop();
        }
        if (this.jmx != null) {
            this.jmx.stop();
        }
    }

    public StatsLogger getStatsLogger(String name) {
        this.initIfNecessary();
        return new CodahaleStatsLogger(this.getMetrics(), name);
    }

    public String getStatsName(String ... statsComponents) {
        if (statsComponents.length == 0) {
            return "";
        }
        String baseName = statsComponents[0];
        String[] names = new String[statsComponents.length - 1];
        System.arraycopy(statsComponents, 1, names, 0, names.length);
        return MetricRegistry.name((String)baseName, (String[])names);
    }
}

