/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.client;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.commons.configuration.Configuration;

public class DeleteLedgerCommand
extends BookieCommand<DeleteLedgerFlags> {
    private static final String NAME = "delete";
    private static final String DESC = "Delete a ledger.";
    private static final String DEFAULT = "";
    private LedgerIdFormatter ledgerIdFormatter;

    public DeleteLedgerCommand() {
        this(new DeleteLedgerFlags());
    }

    public DeleteLedgerCommand(LedgerIdFormatter ledgerIdFormatter) {
        this(new DeleteLedgerFlags());
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    private DeleteLedgerCommand(DeleteLedgerFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, DeleteLedgerFlags cmdFlags) {
        this.initLedgerIdFormatter(conf, cmdFlags);
        try {
            return this.deleteLedger(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private void initLedgerIdFormatter(ServerConfiguration conf, DeleteLedgerFlags flags) {
        if (null == this.ledgerIdFormatter && !flags.ledgerIdFormatter.equals(DEFAULT)) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(flags.ledgerIdFormatter, conf);
        } else if (null == this.ledgerIdFormatter && flags.ledgerIdFormatter.equals(DEFAULT)) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteLedger(ServerConfiguration conf, DeleteLedgerFlags flags) throws IOException, BKException, InterruptedException {
        if (flags.ledgerId < 0L) {
            System.err.println("Ledger id error.");
            return false;
        }
        boolean confirm = false;
        if (!flags.force) {
            confirm = IOUtils.confirmPrompt("Are your sure to delete Ledger : " + this.ledgerIdFormatter.formatLedgerId(flags.ledgerId) + "?");
        }
        try (BookKeeper bookKeeper = null;){
            if (flags.force || confirm) {
                ClientConfiguration configuration = new ClientConfiguration();
                configuration.addConfiguration((Configuration)conf);
                bookKeeper = new BookKeeper(configuration);
                bookKeeper.deleteLedger(flags.ledgerId);
            }
        }
        return true;
    }

    public static class DeleteLedgerFlags
    extends CliFlags {
        @Parameter(names={"-l", "--ledgerid"}, description="Ledger ID", required=true)
        private long ledgerId;
        @Parameter(names={"-f", "--force"}, description="Whether to force delete the Ledger without prompt..?")
        private boolean force;
        @Parameter(names={"-lf", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "";

        public DeleteLedgerFlags ledgerId(long ledgerId) {
            this.ledgerId = ledgerId;
            return this;
        }

        public DeleteLedgerFlags force(boolean force) {
            this.force = force;
            return this;
        }

        public DeleteLedgerFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }
    }
}

